//
//  UIImage+AHP3.h
//  APMHevc
//
//  Created by Kris Tian on 2019/9/21.
//  Copyright © 2019 Alipay. All rights reserved.
//
#undef APM_LOG_TAG
#define APM_LOG_TAG @"UIImage+AHP3: "

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN


@interface UIImage (AHP3)

/**
 UIImage 对应的AHP3 image data。 只有apm_imageWithAHP3Data生成的UIImage才会有此属性，其他的UIImage返回nil
 */
@property (nullable, nonatomic, strong, readonly) NSData *apm_AHP3ImageData;

/**
 根据AHP3 data数据解码成UIImage，从性能上考虑，只返回首帧图。如果需要全部的帧数据，采用Ahp3DecoderImp
 需要首先调用apm_isAHP3ImageData判断是否是AHP3数据，然后再调用apm_imageWithAHP3Data接口

 @param AHP3ImageData AHP3ImageData description
 @return AHP3 data对应的首帧图
 */
+ (nullable UIImage *)apm_imageWithAHP3Data:(NSData *)AHP3ImageData;

/**
 是否是AHP3编码的图片数据

 @param AHP3ImageData 待判断的image data
 @return 是否是AHP3编码的图片数据
 */
+ (BOOL)apm_isAHP3ImageData:(NSData *)imageData;

@end

NS_ASSUME_NONNULL_END
