//
//  Ahp3Transcoder.h
//  APMHevc
//
//  Created by 鲁旭 on 2019/9/20.
//  Copyright © 2019 Alipay. All rights reserved.
//

#ifndef Ahp3Transcoder_h
#define Ahp3Transcoder_h

#undef APM_LOG_TAG
#define APM_LOG_TAG @"Ahp3Transcoder: "

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <ImageIO/ImageIO.h>
#import <MobileCoreServices/MobileCoreServices.h>

@interface Ahp3Transcoder : NSObject

@property (nonatomic, strong) NSData* mAhp3Data;
//init transcoder
-(id)initWithAhp3Data:(NSData *)ahp3Data;
//ahp3 data转码为gif data
-(NSData*)transcodeToGif;

//ahp3 data转码为ayuv data;
//zoom参数为0代表不用裁剪;
//裁剪规则为参数可以大于、小于原图尺寸，会等比例缩放到原图范围然后居中裁剪;
-(NSData *)transcodeToAYUV:(int) zoom_w zoom_h:(int) zoom_h;

//禁止使用系统默认init和new
- (instancetype)init UNAVAILABLE_ATTRIBUTE;
+ (instancetype)new UNAVAILABLE_ATTRIBUTE;

@end
#endif /* Ahp3Transcoder_h */
