//
//  Ahp3DecoderImp.h
//  APMHevc
//
//  Created by alibaba on 2019/9/20.
//  Copyright © 2019年 alibaba. All rights reserved.
//
//
//

#import <UIKit/UIKit.h>

#import "ihevcd_warpper.h"
#import "ahp3_decoder.h"

@interface Ahp3DecoderImp : NSObject

@property (nonatomic,assign) NSInteger width;
@property (nonatomic,assign) NSInteger height;
@property (nonatomic,assign) NSInteger frame_count;
@property (nonatomic,assign) NSInteger loop_count;

@property (nonatomic,assign, readonly) int currentIndex;

@property (nonatomic, strong, readonly) NSMutableDictionary* delayTimeDictionary;

- (AHP3_STATUS_Type)init:(NSData *)data loopCount:(int) loopCount;

- (AHP3_STATUS_Type)decode:(UIImage **) mImage loop:(int) loop_count delay:(int *) delay_ms;

- (AHP3_STATUS_Type)decodeFromIndex:(UIImage **) mImage index:(int) index delay:(int *) delay_ms;

- (uint8_t *)decodeToYUV420P:(int *) delay_ms;

- (AHP3_STATUS_Type)reset;

- (Ahp3Decoder *) getInstance;

@end
