//
//  TaskRecord.h
//  APMultimedia
//
//  Created by brightzheng on 15/4/18.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "DjangoDomainHostDemotion.h"
#import <APMTaskManager/APMTask.h>
#import "APMVirtualProgress.h"

extern NSString* PROGRESS_PERCENTAGE;
extern NSString* PROGRESS_PARTIALBYTES;
extern NSString* PROGRESS_TOTALBYTES;

@interface TaskRecord : APMTask

@property (nonatomic, assign) double progress;              //下载进度
@property (nonatomic, strong) NSString* cloudId;
@property (nonatomic, strong) NSString* reqPath;
@property (nonatomic, strong) NSString* md5;
@property (nonatomic, strong) NSString* token;
@property (nonatomic, strong) NSString* djangoCode;
@property (nonatomic, strong) NSString* traceId;
@property (nonatomic, strong) NSString* massProxyRequestID;//massProxyclient那边的任务ID，用于cancel
@property (nonatomic, strong) DjangoDomainHostDemotion *hostDemotion; //网络ip路由
@property (nonatomic, assign, getter = isDemotion) BOOL demotion; // 是否是降级

// for 埋点
@property (nonatomic, strong) NSDate* startTime;
@property (nonatomic, assign) BOOL isRapid;

@property (nonatomic, strong) id member;                    //批量任务时的成员对象
@property (nonatomic, strong) APMVirtualProgress* virtualProgress;
@property (nonatomic, assign) BOOL useMMTC; //是否使用大数据通道
@property (nonatomic, assign) BOOL useAftsCDN; //是否使用大数据通道

@property (nonatomic, strong) NSString* business;
@property (nonatomic, strong) NSString* bizType;

@property (nonatomic, assign, getter = isBackgroundState) BOOL backgroundState;


//task已经被执行 方便假进度开始处理
- (void)taskRecordStartVirtualProgress;

//task已经结束 方便假进度结束处理
- (void)taskRecordFinishVirtualProgress;

/**
 *  当降级为https时，设置taskRecord的shouldHttps字段为YES
 *
 *  @param taskRecord
 */
- (void)createHostdometion4DownloadWhenDegrade2Https;

@end
