//
//  FlowLimitControlManager.h
//  APMultimedia
//
//  用于双十一十二等大型活动限流控制，对应不同云控级别对不同业务的开关控制
//
//  Created by Monster on 15/10/26.
//  Copyright © 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APMTaskManager/APMTask.h>
#import <APMTaskManager/APMTaskScheduler.h>

@interface FlowLimitControlManager : NSObject


/**
 *  图片下载是否被限流
 *
 *  @param type     下载图片类型，小图、大图、原图
 *  @param complete
 *
 *  @return BOOL
 */
+ (BOOL)limitBigImageDownLoadWithCompletion:(APMTaskCompleteBlock)requestComplete;


/**
 *  图片下载是否被限流
 *
 *  @param type     下载图片类型，小图、大图、原图
 *  @param complete
 *
 *  @return BOOL
 */
+ (BOOL)limitThumbnailImageDownLoadWithCompletion:(APMTaskCompleteBlock)requestComplete;


/**
 *  文件下载是否被限流
 *
 *  @param complete
 *
 *  @return BOOL
 */
+ (BOOL)limitFileDownloadWithRequestCompletion:(APMTaskCompleteBlock)requestComplete;

/**
 *  视频下载是否被限流
 *
 *  @param complete
 *
 *  @return BOOL
 */
+ (BOOL)limitVideoDownLoadWithCompletion:(APMTaskCompleteBlock)complete;

/**
 *  语音下载是否被限流
 *
 *  @param complete
 *
 *  @return BOOL
 */
+ (BOOL)limitVoiceDownLoadWithCompletion:(APMTaskCompleteBlock)complete;

+ (NSError *)flowLimitError;
+ (NSError *)flowLimitErrorWithUserInfo:(NSDictionary *)userInfo;

@end
