//
//  ImageUrlBuilder.h
//  APMultimedia
//
//  Created by Cloud on 2016/10/21.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface DjangoUrlBuilder : NSObject

/**
 根据cloud ID(AFTS/Django)生成对应的文件下载url

 @param cloudId cloud ID(AFTS/Django), 包括公有和私有资源
 @param bizType 业务标志
 @param ishttps  是否是https
 @return cloudId对应的文件下载url
 */
+ (NSString *)buildFileUrlWithCloudID:(NSString *)cloudId bizType:(NSString *)bizType;
+ (NSString *)buildFileUrlWithCloudID:(NSString *)cloudId bizType:(NSString *)bizType isHttps:(BOOL)ishttps;

/**
 根据cloud ID(AFTS/Django)生成对应的图片下载url并凭借zoom参数

 @param cloudId cloud ID(AFTS/Django), 包括公有和私有资源
 @param zoom zoom参数
 @param bizType 业务标志
 @param forNetwork 是否直接为网络请求准备的，比如图片公有上传生成的url，并不是用于直接下载的。
 @return cloudId+zoom对应的文件下载url
 */
+ (NSString *)buildImageUrlWithCloudId:(NSString *)cloudId zoom:(NSString *)zoom bizType:(NSString *)bizType forNetwork:(BOOL)forNetwork;

/**
 为公有图片资源id生成原图下载接口

 @param cloudId 公有图片资源id
 @return cloudId对应的下载url
 */
+ (NSString *)buildImageUrlWithPublicCloudId:(NSString *)cloudId bizType:(NSString *)bizType;



#pragma mark  - 视频CDN URL
extern NSString* const kAPVideoPresetOriginal;

extern NSString* const kAPVideoPreset1080P;

extern NSString* const kAPVideoPreset540P;

extern NSString* const kAPVideoPreset360P;

/// 根据视频id+preset，生成对应的视频url
/// @param identifier 视频id
/// @param bizType 业务标志，会拼接在url中，不建议使用特殊字符
/// @param preset 码率
+ (NSString *)buildVideoUrlWithCloudId:(NSString *)identifier
                               bizType:(NSString *)bizType
                                preset:(NSString *)preset;
+ (NSString *)buildVideoUrlWithCloudId:(NSString *)identifier
                               bizType:(NSString *)bizType
                                preset:(NSString *)preset
                               isHttps:(BOOL)ishttps;

/**
 是否是线上环境

 @return 是否是线上环境
 */
+ (BOOL)isProductionEnv;

/**
 将外部图片url转化成afts CDN对应的图片URL

 @param url 非AFTS url
 @param zoom 图片zoom参数
 @param zoom2 智能裁切的降级参数，如果存在的话，否则传入nil
 @param bizType 业务标志
 @return 外部url对应的外部fts CDN图片URL
 */
+ (NSString *)buildAftsCdnUrlWithUrl:(NSString *)url
                                zoom:(NSString *)zoom
                               zoom2:(NSString *)zoom2
                             bizType:(NSString *)bizType;

///  根据id生成对应的url, 包含私有AFTS 资源
/// @param fileid 文件id
/// @param isImg  是否是图片
/// @param zoom  图片的zoom参数
/// @param ishttps  是否是https
/// @param ispublic  是否共有
/// @param bz  业务标志
+(NSString*)getUrlWithFileId:(NSString*)fileid isImage:(BOOL)isImg imageZoom:(NSString*)zoom isHttps:(BOOL)ishttps isPublic:(BOOL)ispublic bizType:(NSString*)bz;

@end
