//
//  DjangoDomainHostDemotion.h
//  APMultimedia
//
//  Created by Monster on 15/7/5.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
typedef enum : NSUInteger {
    HttpDomainHostDemotion_Api,
    HttpDomainHostDemotion_UpLoad,
    HttpDomainHostDemotion_DownLoad,
} HttpDomainHostDemotion_Type;

//钱包环境：测试、预发、发布环境
typedef enum : NSUInteger {
    HttpDomainHostDemotion_AlipayDebug,
    HttpDomainHostDemotion_AlipayPreRelease,
    HttpDomainHostDemotion_AlipayRelease,
} HttpDomainHostDemotion_AlipayEnv;


@interface DjangoDomainHostDemotion : NSObject
//记录降级处理类型
@property(nonatomic, assign)HttpDomainHostDemotion_Type type;

//记录是否需要https
@property(nonatomic, assign)BOOL shouldHttps;


/**
 *  降级类型创建
 *
 *  @param type 降级域名类型
 *
 *  @return
 */
+(DjangoDomainHostDemotion*)createHostDemontion:(HttpDomainHostDemotion_Type)type;


//钱包环境，用来关联本SDK的环境
+ (HttpDomainHostDemotion_AlipayEnv)fetchAlipayEnv;



/**
 *  获取URL的host字段
 *
 *  @return host
 */
- (NSString*)fetchDemontionHost;
@end
