//
//  APMFileUploadRequest.h
//  APMFileTransfer
//
//  Created by Kris Tian on 2019/7/23.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>


typedef NS_ENUM(NSUInteger, APMTransferChannel) {
    APMTransferChannelIgnore,
    APMTransferChannelMMTC,
    APMTransferChannelDjango,
};





@interface APMUploadRequest : NSObject

/**
 上传时额外的http头部参数，需要业务方和服务器端协商
 */
@property (nonatomic, copy) NSDictionary<NSString *,NSString *> *extraHeaders;

/**
 需要业务方和服务器端协商, 额外的上传参数，非头部
 */
@property (nonatomic, copy) NSDictionary<NSString *,NSString *> *extraParams;

/**
 上传操作的超时时间，默认时间120s
 */
@property (nonatomic, assign) NSTimeInterval timeout4Upload;

/**
 上传文件的名称，服务器端可能会根据文件名后缀判断文件类型
 */
@property (nonatomic, copy) NSString *fileName;

/**
 业务标志，方便业务统计和问题排查。
 */
@property (nonatomic, copy) NSString *bizType;

/**
 *  缓存过期时间，unix时间戳，0表示永不过期,按照缓存默认的策略淘汰，默认为0，
 *  触发生成缓存时此设置有效，如：下载，上传非localId的文件，及生成由其它图片裁剪的图片
 */
@property (nonatomic, assign) int expirationTime;

/**
 是否是需要加密传输
 */
@property (nonatomic, assign) BOOL needCrypto;



@property (nonatomic, assign) APMTransferChannel transferChannel;


@end

