//
//  APMFileUploader.h
//  APMFileTransfer
//
//  Created by Kris Tian on 2019/7/23.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APMUploadRequest.h"
#import "APMUploadResponse.h"


@interface APMBaseUploader : NSObject

+ (instancetype)shareInstance;

/**
 根据request，上传data数据到服务器端

 @param data 上传的数据
 @param uploadRequest 上传的请求信息
 @param start 开始执行上传的回调
 @param progress 上传进度回调
 @param completion 上传完成回调
 @return 这次上传的任务标志，可用于取消上传任务
 */
- (NSString *)uploadWithFileData:(NSData *)data
                         request:(APMUploadRequest *)uploadRequest
                           start:(APMStartUploadBlock)start
                        progress:(APMProcessiveBlock)progress
                        complete:(APMUploadResponseCompletion)completion;

/**
 取消上传的任务

 @param taskId 上传的任务标志
 */
- (void)cancelUploadTask:(NSString *)taskId;

@end

