//
//  AudioRemoteLog.h
//  APMultimedia
//
//  Created by 鲁旭 on 2020/1/15.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef enum: NSInteger {
    ERROR_AUDIO_ENCODER = -1,
    ERROR_AUDIO_PERMISSION = -2,
    ERROR_AUDIO_PARAMS = -3,
    ERROR_AUDIO_DEVICE = -4,
    ERROR_AUDIO_INTERUPTED = -5,
    ERROR_AUDIO_QUEUE_START = -6,
    ERROR_AUDIO_TIME_NOT_ENOUGH = -7,
    ERROR_AUDIO_QUEUE = -8,
    ERROR_AUDIO_SAMPLEBUFFER = -9,
    AUDIO_RECORD_SUCCESS = 0
}AMMAudioRecordError;

@interface AudioRemoteLog : NSObject

+ (void)logForAudioRecord:(int)result
                     size:(int)size
                     time:(NSTimeInterval)time
                 moreInfo:(NSDictionary *)info;

+ (void)logForCompressAudio:(int)result
                       size:(int)size
                       time:(NSTimeInterval)time;
@end

NS_ASSUME_NONNULL_END
