//
//  APAudioEncoderEngine.h
//  APMultimedia
//
//  Created by 鲁旭 on 2020/1/14.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APAudioEncoder.h"
NS_ASSUME_NONNULL_BEGIN

@interface APMAudioEncoderManager : NSObject

/**
 *共享对象
 *
 *@return 共享对象
 */
+(instancetype)sharedInstance;

/**
 *注册默认编码器
 *
 */
-(void)registerDefaultEncoder;

/**
 *注册编码器
 *
 */
-(BOOL)registerEncoderWithFormat:(NSNumber *)format encoderClassName:(NSString *)encoder;

/**
 *移除编码器
 *
 */
-(BOOL)unregisterEncoderWithFormat:(NSNumber *)format;

/**
 *清除所有编码器
 *
 */
-(void)removeAllEncoders;

/**
 *是否为可用格式
 *
*/
- (BOOL)isAvaliableFormat:(NSNumber *)format;
/**
 *获取对应格式的编码器
 *
 */
-(id<APAudioEncoder>)getEncoderWithFormat:(NSNumber *)format;

@end

NS_ASSUME_NONNULL_END
