//
//  APMHighAvailabilityProcessor.h
//  APMAftsCommon
//
//  Created by 鲁旭 on 2020/5/22.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface APMHighAvailabilityProcessor : NSObject
/**
 将url转换到高保障url下，如果url和业务标志支持，则h返回对应的高保障url，否则则返回原始传入的url
 
 @param urlStr 需要转换的url，
 @param bizType 业务标志
 @param isPicture 是否是图片
 @return 如果url和业务标志支持，则h返回对应的高保障url，否则则返回原始传入的url
 */
+ (NSArray *)highAvailabilityUrlForUrl:(NSString *)urlStr bizType:(NSString *)bizType isPicture:(BOOL)isPicture;


@end

NS_ASSUME_NONNULL_END
