//
//  APSyncUpMessage.h
//  APLongLinkService
//
//  Created by cuinacai on 15/8/11.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface SyncUpMessage : NSObject
/**
 *  业务类型,非空
 */
@property(nonatomic,strong)NSString *biz;
/**
 *  业务bizId,可空
 */
@property(nonatomic,strong)NSString *bizId;
/**
 *  PB类型数据
 */
@property(nonatomic,strong)NSData *msgDataPB;
/**
 *  json类型数据
 */
@property(nonatomic,strong)NSString *msgData;
/**
 *  发送时间,0为立即发送,默认立即发送,单位秒
 */
@property(nonatomic)NSUInteger sendTime;
/**
 *  最迟发送时间,超过该时间未发送丢弃,0为不超时确保成功,默认不超时确保成功,单位秒
 */
@property(nonatomic)NSUInteger expireTime;

/**
 *  当前用户id，如果为空会采用默认的user id
 */
@property(nonatomic,strong)NSString *currentUserId;

/**
 *  当前appname，如果为空会采用主APP的AppName
 */
@property(nonatomic,strong)NSString *currentAppName;
@end
