//
//  DTLongLinkControl.h
//  APLongLinkService
//
//  Created by alipay\kuohai on 14-9-14.
//  Copyright (c) 2014年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AntNetworkAdapter/AntNetworkAdapter.h>

//降级开关
#define AP_LONGLINK_DOWNGRAGE_CONFIG @"AP_LONGLINK_DOWNGRAGE_CONFIG"
extern NSString * const APLongLinkErrorNotification;
extern NSString * const APLongLinkReLoginNotification;
extern NSString * const KSyncIdleNotification;

typedef NS_ENUM(NSInteger,SYNCRegionChangeStatus)
{
    SYNCRegionChangeStatusWillChange = 0, //开始切换
    SYNCRegionChangeStatusChange,         //切换
    SYNCRegionChangeStatusDidChange,      //切换完成
};

@protocol MAAccessInterface;

@protocol SyncInfoDelegate <NSObject>
/**
 *	@brief	取用户ID
 *
 */
- (NSString*)userId;
/**
 *	@brief	取用户登录态
 *
 */
- (BOOL)isUserLogin;
/**
 *	@brief	获取cookie
 *
 */
- (NSString*)shortLinkCookie;

@end

@interface DTLongLinkControl : NSObject
/*
 * instance
 */
+ (DTLongLinkControl *)sharedInstance;
/*
 * 语言
 */
@property (nonatomic, strong) NSString * language;
@property(nonatomic, assign)BOOL syncHasIdle;
@property (nonatomic, weak) id<SyncInfoDelegate> infoDelegate;
/**
 *	@brief	设置网络实现接口access
 *
 *	@return void
 */
+(void)setNetAccessInstance:(id<MAAccessInterface>)access;
/**
 *	@brief	设置初始化参数
 *
 *	@param 	url 	    url
 *	@param 	port 	    端口
 *	@param 	appName 	客户端名称
 *	@param 	appVersion 	客户端版本
 *
 *	@return
 */
- (void)setDirectAsyncURL:(NSString *)url port:(NSInteger)port appName:(NSString *)appName appVer:(NSString *)appVersion;

/**
 *	@brief  设置id。无id可不设置。
 *
 *	@param 	did 	utdid
 *	@param 	tid 	移动快捷tid
 *
 *	@return
 */
- (void)setDid:(NSString *)did tid:(NSString *)tid;

/**
 *	@brief	获取当前设备当前应用唯一id，用于消息指定设备推送
 *
 *	@return	cdid
 */
- (NSString *)getCdid;

/**
 *	@brief	创建业务内长连接，初始化设备数据
 *
 *	@return
 */
- (void)createAsyncSocket;

/**
 *	@brief	断开长连接
 *
 *	@return
 */
- (void)closeAsyncSocket;

/**
 *	@brief	用户登陆初始化业务内长连接数据
 *
 *	@param 	userId 	    用户名
  *	@param 	sessionId   用于校验session合法性
 *
 *	@return
 */
- (void)sendBindUser:(NSString *)userId sessionId:(NSString *)sessionId;

/**
 *	@brief	解绑当前连接用户
 *
 *	@return
 */
- (void)sendUnBindUser;

#ifdef USE_MPASS_SDK
/**
 *  @brief    解绑当前连接用户
 *
 *  @param     userId      用户名
 *  @param     sessionId   用于校验session合法性
 *
 *    @return
 */
- (void)sendUnBindUser:(NSString *)userId sessionId:(NSString *)sessionId;
#endif

/**
 *	@brief	数据通道改变
 *
 *	@return
 */
- (void)syncChangeDataChannel;
/**
 * 框架数据库切换和登录通知有延迟,需要提前切换用户id
 */
- (void)updateUserId:(NSString *)userId sessionId:(NSString *)sessionId;
/**
 *	@brief	设置短连接的业务
 *  @param  短连接的业务List
 *	@return
 */
- (void)setShortLinkList:(NSArray*)bizList;
/**
 *	@brief	短连接开关
 *  @param  开关
 *	@return
 */
- (void)setShortLinkOpen:(BOOL)open;
/**
 *	@brief  短连接的轮询时间配置
 *  @param  短连接的轮询时间
 *	@return
 */
- (void)setSyncPollTime:(NSDictionary*)syncPollTime;
/**
 *	@brief  是否发送所有业务
 *  @param 是否发送所有业务
 *	@return
 */
- (void)setSyncSendAllBiz:(BOOL)sendAllBiz;
/**
 *	@brief  sync_cfg配置信息
 *  @param  sync_cfg
 *	@return
 */
- (void)setSyncConfig:(NSDictionary*)syncCfg;
/**
 *    @brief  app/region切换
 *    @param  status 状态
 *    @return
 */
- (void)regionChange:(SYNCRegionChangeStatus)status changeInfo:(NSDictionary*)info;

@end
