//
//  DTLongLinkBusiness.h
//  APLongLinkService
//
//  Created by alipay\kuohai on 14-9-8.
//  Copyright (c) 2014年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SyncUpMessage.h"

typedef NS_ENUM(NSInteger, SyncNetType)
{
    SyncNetTypeAvailable = 0,//Sync可用
    SyncNetTypeNotAvailable  //Sync不可用
    
};

typedef NS_ENUM(NSInteger, SyncBizType)
{
    SyncBizTypeUser = 0,//User类型用户
    SyncBizTypeDevice  //Device类型用户
    
};

typedef NS_ENUM(NSInteger,NetConnectType)
{
    NetConnectTypeNotAvailable = 0, //当前网络不可用
    NetConnectTypeConnecting,       //连接中
    NetConnectTypeConnected,        //连接上
    NetConnectTypeConnectFailed     //连接失败
};

typedef NS_ENUM(NSInteger,NetReceivingStatus)
{
    NetReceivingStatusReceivingData = 1, //收取中
    NetReceivingStatusNoData,       //没有数据
};

typedef NS_ENUM(NSInteger,RegisterBizCallbackResult)
{
    RegisterBizCallbackResultSucc = 0,     //成功
    RegisterBizCallbackResultParamErr,     //参数有误
    RegisterBizCallbackResultCallbackErr,  //callback没有实现SyncDownCallback里面的接口
    RegisterBizCallbackResultFail,         //注册失败
};

//监听通知
extern NSString * const APConnectionStatusNotification;
//Notification status info key
extern NSString * const APConnectionStatusKey;
//Sync带Push通知
extern NSString * const APSyncPushDataNotification;
//收取中的通知
extern NSString * const APReceivingStatusNotification;
extern NSString * const APReceivingStatusKey;
extern NSString * const APSyncAppNameKey;

typedef NS_ENUM(NSInteger,SyncUpState)
{
    SyncUpStateSucces = 0, //成功
};

@interface SyncUpCallbackInfo : NSObject
//业务名字
@property(nonatomic,strong)NSString *biz;
//发送时候返回的消息id
@property(nonatomic,strong)NSString *msgID;
//当前appname
@property(nonatomic,strong)NSString *appName;
@end

@protocol SyncUpCallback <NSObject>
/**
 *	@brief	发送成功后的回调，该方法已经废弃
 *          请用 [SyncUpCallback sendResultBizInfo:syncUpState:]代替
 *  
 *  @param  biz 业务名字
 *	@param 	msgID 	发送时候返回的消息id
 *	@param 	state 	状态
 *
 */
- (void)sendResultBiz:(NSString*)biz msgID:(NSString*)msgID syncUpState:(SyncUpState)state;

/**
 *    @brief    发送成功后的回调
 *
 *    @param     info      回调信息
 *    @param     state     状态
 *
 */
- (void)sendResultBizInfo:(SyncUpCallbackInfo*)info syncUpState:(SyncUpState)state;
@end

@protocol SyncDownCallback <NSObject>
/**
 *    @brief    SYNC消息回调
 *
 *    @param    notification  notification.userInfo里面包含SYNC相关信息
 *                            notification.name 是业务名字
 *
 */
- (void)onReceiveMessageNotification:(NSNotification*)notification;

@end

@interface DTLongLinkBusiness : NSObject

/**
 *	@brief	通用业务通过传送appid得到应该监听的长连接消息
 *
 *	@param 	appId 	注册appId
 *
 *	@return 消息字符串
 */
+ (NSString *)longLinkNotifyWithAppId:(NSString *)appId;

/**
 *	@brief	老业务获取监听的长连接消息
 *
 *	@param 
 *
 *	@return 消息字符串
 */
+ (NSString *)longLinkNotifyUserInfoKey;

/**
 *	@brief	发送消息
 *
 *	@param 	data 	发送内容
 *	@param 	biz 	发送方
 *
 *	@return	void
 */
+ (void)sendMessage:(NSDictionary *)data biz:(NSString *)biz;

/**
 *	@brief	注册SyncBizTypeUser业务 （注册业务接口调用前需要注册业务通知来监听长连接通道发送过来的业务消息）
 *
 *	@param 	biz 	业务名称
 *
 *	@return	void
 */
+ (void)registerBiz:(NSString *)biz;

/**(9.9.5开始废弃,业务不许要调用,只要申请业务时候配置即可)
 *	@brief	注册SyncBizTypeUser业务并立即同步 （注册业务接口调用前需要注册业务通知来监听长连接通道发送过来的业务消息）
 *
 *	@param 	biz 	业务名称
 *
 *	@return	void
 */
+ (void)registerBizAndSync:(NSString *)biz;

/**(9.9.5开始废弃,业务不许要调用,只要申请业务时候配置即可)
 *	@brief	取消业务注册
 *
 *	@param 	biz 	业务名称
 *
 *	@return	void
 */
+ (void)unRegisterBizStopSync:(NSString *)biz;

/**
 *	@brief	消息处理完成通知通道层
 *
 *	@param 	dic 	返回处理消息信息
 *
 *	@return
 */
+ (void)responseMessageNotify:(NSDictionary *)dic;

/**
 *	@brief	广播业务上传md5到spanner
 *
 *	@param 	md5 广播业务上传到spanner的md5
 *
 *	@return
 */
+(void)reportMsgHandled:(NSString*)md5;

/**
 *	@brief	全量刷新
 *
 *	@param 	biz 	业务名称
 *s
 *	@return
 */
+ (void)totalRefreshBiz:(NSString *)biz;

/**
 *	@brief	业务方通知更新本地和服务端同步点
 *
 *	@param 	biz 	业务名称
  *	@param 	sKey 	业务方从服务端取回的同步点
 *
 *	@return
 */
+ (void)refreshSkey:(NSString *)biz sKey:(NSString *)sKey;

/**
 *	@brief	业务方通知更新本地和服务端同步点
 *
 *	@param 	biz 	业务名称
 *
 *	@return
 */
+ (NSString *)getBizSkey:(NSString *)biz;

/**
 *	@brief	查询业务是否注册上报成功并可用
 *
 *	@param 	biz 	业务名称
 *
 *	@return	返回业务是否理解可用状态
 *          SyncNetTypeAvailable   可用
 *          SyncNetTypeNoAvailable 不可用
 */
+ (SyncNetType)querySyncNetType:(NSString *)biz DEPRECATED_MSG_ATTRIBUTE("Please do not use.");

/**
 *  Sync是否可用
 *  当连接建立成功，并且发出init包收到了服务端的init回复后表示可用,否则不可用
 *
 *  @return YES(可用)/NO(不可用)
 */
+ (BOOL)isSyncAvailable;
/**
 *	网络连接状态
 */
+(NetConnectType)connectStatus;
/**
 *  通知SyncSDK已经注册通知监听,可以接收Sync消息
 *  如果不调用该接口则不分发Sync消息,消息会积压在SyncSDK的数据库
 *  @param 	biz 	业务名称
 *  @return 调用成功或者失败YES/NO
 */
+(BOOL)hasRegisterNotificationWithBiz:(NSString*)biz;
/**
 *  通知SyncSDK已经取消通知监听,不再接收Sync消息
 *  调用该接口后不会再分发Sync消息,消息会积压在SyncSDK的数据库
 *  @param 	biz 	业务名称
 *  @return 调用成功或者失败YES/NO
 */
+(BOOL)unRegisterNotificationWithBiz:(NSString*)biz;

/**
 *	@brief	发送Sync数据
 *
 *	@param 	msg         业务名称
 *
 *	@return msgID
 */
+ (NSString*)sendSyncMsg:(SyncUpMessage *)upMsg;
/**
 *  通知SyncSDK已经注册通知监听,可以接收Sync消息发送结果,默认是主APP的appname
 *  @param biz biz为业务key
 *  @param listener 强引用
 *  @return 调用成功或者失败YES/NO
 */
+(BOOL)registerSendBiz:(NSString*)biz callback:(id<SyncUpCallback>)callback;
/**
 *  通知SyncSDK已经注册通知监听,可以接收Sync消息发送结果
 *  @param biz biz为业务key
 *  @param listener 强引用
 *  @param appName  appName
 *  @return 调用成功或者失败YES/NO
 */
+(BOOL)registerSendBiz:(NSString*)biz callback:(id<SyncUpCallback>)callback appName:(NSString*)appName;
/**
 *	@brief	发送Sync数据,需要回调,调用该接口前必须保证已经调用注册了监听(registerSendBiz:callback:),否则抛异常
 *
 *	@param 	msg         业务名称
 *
 *	@return msgID
 */
+ (NSString*)sendSyncMsgNeedCallback:(SyncUpMessage *)upMsg;
/**
 *	@brief	取消发送
 *
 *	@param 	msgID 	发送时候返回的消息id
 *
 *	@return msgID
 */
+ (void)cancelSendSyncMsg:(NSString*)msgID;
/**
 *	@brief	上报统计
 *
 *	@param 	biz         业务名字
 *	@param 	key         key
 *	@param 	version     对应的版本号
 *	@param 	timestamp 	时间
 *
 *	@return void
 */
+(void)reportBizRequestWithBiz:(NSString*)biz key:(NSString*)key version:(NSString*)version timestamp:(long long)timestamp DEPRECATED_MSG_ATTRIBUTE("Please use [APApplicationInfo reportBizRequestWithBiz:key:version:timestamp:appName:]");
+(void)reportBizRequestWithBiz:(NSString*)biz key:(NSString*)key version:(NSString*)version timestamp:(long long)timestamp appName:(NSString*)appName;

/**
 *    @brief    4011上报接口
 *
 *    @param     key       key
 *    @param     info     客户端埋点标记
 *
 *    @return void
 */
+(void)reportSyncCoverageStatistic:(NSString*)key extInfo:(NSString*)info;
/**
 *    @brief    向sync sdk注册callback
 *              当注册成功该回调后，如果有该业务的消息sync会回调callback分发消息
 *              注：1.业务方需要持有callback实例的引用，因为sync模块不对callback进行强引用
 *                 2.biz和appName是组合成唯一标志，biz和appName一样的情况会覆盖之前的注册
 *
 *    @param    callback    回调，weak引用，生命周期自己管理
 *    @param    biz         业务名字，在SyncDownCallback的回调里面会通过notification.name带回来
 *    @param    appName     APP名字，传空默认使用主APP名字，在SyncDownCallback的回调里面可以
                            通过notification.userInfo[APSyncAppNameKey]获取
 *
 *    @return 注册结果
 */
+(RegisterBizCallbackResult)registerBizCallback:(id<SyncDownCallback>)callback biz:(NSString*)biz appName:(NSString*)appName;
/**
 *  @brief    通知SyncSDK已经取消通知监听，不再接收Sync消息
 *            调用该接口后不会再分发Sync消息，消息会积压在SyncSDK的数据库中
 *
 *  @param    biz           业务名字
 *  @param    appName       APP名字，传空默认使用主APP名字
 *  @return   调用成功或者失败YES/NO
 */
+(BOOL)unRegisterCallbackWithBiz:(NSString*)biz appName:(NSString*)appName;
@end
