//
//  MAStatusInterface.h
//  Interface
//
//  Created by cuinacai on 15/3/27.
//  Copyright (c) 2015年 cuinacai. All rights reserved.
//
#import <Foundation/Foundation.h>

@protocol MAAccessInterface;

@protocol MAStatusInterface <NSObject>
@optional
/**
 *	@brief	init成功后回调
 *
 *	@param 	access     MAAccess
 *
 *	@return
 */
- (void)accessDidInit:(id<MAAccessInterface>)access;

/**
 *	@brief	登录成功后回调
 *
 *	@param 	access     MAAccess
 *
 *	@return
 */
- (void)accessOnLogin:(id<MAAccessInterface>)access;

/**
 *	@brief	登录成功后回调
 *
 *	@param 	access     MAAccess
 *
 *	@return
 */
- (void)accessOnLoginOut:(id<MAAccessInterface>)access;
/**
 *	@brief	连接状态回调
 *
 *	@param 	status     MAAccessStatus
 *
 *	@return
 */
-(void)connectStatus:(NSInteger)status;
/**
 *  短连接通道是否开启了
 *
 *  @param open yes开启，no关闭
 */
-(void)noticeShortChannelIsOpen:(BOOL)open;
/**
 *	@brief	建连时间统计回调
 *
 *	@param 	tcp握手时间，ssl握手时间，总时间
 *
 *	@return
 */
-(void)connectStatistic:(NSDictionary*) kvs;
/**
 *    @brief    统一库埋点上报
 */
-(void)bifrostErrorReport:(NSDictionary *)kvs;

/**
 *    @brief    发生不可预测的可能致命错误，比如ANR或者卡死
 */
-(void)noticeFatalErrorDomain:(NSString*)domain info:(NSDictionary *)info;

//通知发送重新登录
-(void)reLoginNotice;

//通知已经发送了切前台
-(void)appEnterForground;
//mmtp降级到spdy
-(void)mmtpToSPDY;
/**
 App当前处于后台
 注意：！！如果main之前获取，认为是前台
 @return YES 后台 ; NO前台或回前台过程中
 */
- (BOOL)isBackground;

//是否是VPN连接
- (BOOL)isVPNConnected;
@end
