//
//  DTRTMSInterface.h
//  APBaseInterfaceAdapter
//
//  Created by yizhangbiao on 2022/9/19.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface DTRTMSInterface : NSObject

+ (instancetype)sharedInstance;

//设备信息
- (NSString *)deviceVersion;

//版本号
- (NSString *)productVersion;

//前后台
- (BOOL)isBackground;

//app名称
- (NSString *)productName;

- (void)logExceptionTypeFeel:(NSString *)name
                      subBiz:(nullable NSString *)subBiz
                      reason:(nullable NSString *)reason
                        code:(nullable NSNumber *)code
                    userInfo:(nullable NSDictionary *)userInfo;


//获取userID
- (NSString *)userId;

//获取SessionId
- (NSString *)sessionId;

//获取productID
- (NSString *)productId;

//获取UTDID
- (NSString *)UTDID;

//检查是否登录，未登录发起免登
- (BOOL)checkAndDoLogin:(BOOL)foreground;

//发起免登，foreground决定免登失败是否弹出登陆页
- (BOOL)doLogin:(BOOL)foreground;

//获取AuthCode
- (NSString *)openSecurityAuthCode;
@end
