//
// Created by 李小泉 on 2021/5/18.
//

#ifndef BIFROST_DTN_ERROR_CODE_H
#define BIFROST_DTN_ERROR_CODE_H
//error type
enum ErrCmdType {
    kEctOK          = 0,
    kEctFalse       = 1,
    kEctDial        = 2,
    kEctDns         = 3,
    kEctSocket      = 4,
    kEctHttp        = 5,
    kEctNetMsgXP    = 6,
    kEctEnDecode    = 7,
    kEctServer      = 8,
    kEctLocal       = 9,
    kEctTls         = 10,
    kEctMultiLink   = 11,
    kEctHttp2       = 12,

    kEctUnKnown     = 14,
};

//error code local
enum {
    kEctLocalOk                     = 0,
    kEctLocalTaskTimeout            = -1,
    kEctLocalTaskRetry              = -2,
    kEctLocalStartTaskFail          = -3,
    kEctLocalAntiAvalanche          = -4,
    kEctLocalChannelSelect          = -5,
    kEctLocalNoNet                  = -6,
    kEctLocalCancel                 = -7,
    kEctLocalClear                  = -8,
    kEctLocalReset                  = -9,
    kEctLocalPause                  = -10,
    kEctLocalResume                 = -11,
    kEctLocalTaskParam              = -12,
    kEctLocalCgiFrequcencyLimit     = -13,
    kEctLocalChannelID              = -14,
    kEctLocalRedirectRetry          = -15,
    kEctLocalProtocolError          = -16,
    kEctLocalMemoryLimit            = -17,
    kEctLocalFileOpen               = -18,
    kEctLocalFileWrite              = -19,
    kEctLocalUncompress             = -20,
    kEctLocalInnerError             = -21,
    kEctLocalMd5CheckFail           = -22,
    kEctLocalSHACheckFail           = -23,
    kEctLocalFileLenError           = -24,
    kEctLocalInvalidUrl             = -25,
    kEctLocalConflictTask           = -26,
    kEctLocalSOS                    = -27,
    kEctLocalWaitTimeout            = -28,
    kEctLocalTaskMaxCountLimit      = -29,
};

// -600 ~ -500 //kEctHttp , kEctNetMsgXP; other http -12000 ~ -19999
enum {
    kEctLongFirstPkgTimeout         = -500,
    kEctLongPkgPkgTimeout           = -501,
    kEctLongReadWriteTimeout        = -502,
    kEctLongTaskTimeout             = -503,

    kEctHttpFirstPkgTimeout         = -500,
    kEctHttpPkgPkgTimeout           = -501,
    kEctHttpReadWriteTimeout        = -502,
    kEctHttpTaskTimeout             = -503,

    kEctHttpStatus                  = -504,
    kEctHttpBody                    = -505,
    kEctHttpUrl                     = -506,
    kEctHttpHeader                  = -507,
    kEctHttpUploadPkgPkgTimeout     = -508,
    kEctHttpMultipleHeaders         = -509,
    kEctHttpNetChangeFirstPkgTimeout= -510,
    kEctHttpNetChangePkgPkgTimeout  = -511,
    kEctHttpServerDownStatus        = -512,

    kEctHttpPkgErrorStarts          = -12000,
    kEctHttp30xLocationMiss         = -12998,
    kEctHttpPkgErrorEnds            = -12999,
};
// http2 -30000 ~ -39999
enum {
    kEtcHttp2ErrorStarts            = -30000,
    kEctHttp2ErrorEnds              = -39999,
};
// tls -20000 ~ -29999
enum {
    kEtcTlsErrorStarts              = -20000,
    kEctTlsErrorEnds                = -29999,
};

// -20000 ~ -10000
enum {
    //    kEctSocketNetworkChange = -10086,
    //    kEctSocketMakeSocketPrepared = -10087,
    //    kEctSocketWritenWithNonBlock = -10088,
    //    kEctSocketReadOnce = -10089,
    kEctSocketShutdown              = -10090,
    kEctSocketNoopTimeout           = -10091,
    //    kEctSocketSendErr = -10092,
    kEctSocketReadTimeout           = -10093,

    //    kEctNetMsgXPHandleBufferErr = -10504, //longlink_unpack return error code

    kEctDnsMakeSocketPrepared       = -10606,

    kEctStreamFin                   = -10700,//stream recv fin frame in quic or http2
};

// -60000 ~ -69999 Reserved for application layer(Android/iOS/Linux and many more), don't use.
#endif //BIFROST_DTN_ERROR_CODE_H
