//
//  QualityModelMgr.h
//  AMNet
//  质量模型管理类
//  Created by feisong on 16/9/28.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

//网络质量评级 A(优) B(良) C(中) D(差)
typedef enum {
    QOS_LEVEL_A = 1,
    QOS_LEVEL_B,
    QOS_LEVEL_C,
    QOS_LEVEL_D,
} QOSLEVEL;

@interface QualityModelMgr : NSObject
@property(nonatomic,strong) NSMutableDictionary *startRpcTrafficDict;//记录rpc发送时的流量值
@property(nonatomic) double trafficSpeed;
@property(nonatomic) double westSpeed;
/**
 * 获得单例
 */
+(instancetype)shareInstance;
/**
 * 调用系统接口 获取dataId对应的rpc发送时的流量值
 */
-(void)saveStartRpcTraffic:(UInt64)dataId;
/**
 * 配置相关参数
 */
-(void)setQosConfig:(NSDictionary*)dict;
/**
 * 外部调用 获取最终网络质量评级
 */
-(QOSLEVEL)getQosLevel;
/**
 * qos信息 埋点时用
 */
-(NSString*)qosMsg;
@end
