//
//  MnetThreadPosixAccess.h
//  MnetThread
//
//  Created by yangxiao on 15/3/18.
//  Copyright (c) 2015年 yangxiao. All rights reserved.
//

#ifndef MnetThread_MnetThreadPosixAccess_h
#define MnetThread_MnetThreadPosixAccess_h
#include <map>
#include <vector>
#ifdef USE_OLD_MNET
#include "mnet_command_queue.hpp"
#else
#include <time.h>
#include <sys/time.h>
#include<unistd.h>
#include<fcntl.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif
#include "MnetCommonDefine.h"
#include "bifrost.h"
#define LOG_DEBUG(...) logWriteMdap(0,## __VA_ARGS__)
#define LOG_INFO(...) logWriteMdap(1,## __VA_ARGS__)
#define LOG_WARN(...) logWriteMdap(2,## __VA_ARGS__)
#define LOG_ERROR(...) logWriteMdap(3,## __VA_ARGS__)
#define LOG_FATAL(...) logWriteMdap(4,## __VA_ARGS__)

#define DIAGNOSE(...) diagnoseLog(__VA_ARGS__)

#ifdef USE_OLD_MNET
struct RspCompensateInfo;

//posix部分的初始化
int mnet_thread_posix_init(void * threadObj);

//开始网络线程循环的posix接口
void mnet_thread_loop();

//请求网络线程的posix接口
unsigned int push_request_into_queue(EQueueMsgType& command,bool directionNormal = true,bool needNotice = true,bool longlink = true);

//请求停止网络线程的posix接口
void mnet_thread_quit();

//自身指令的发送，目前用于dns解析结果通知、联通性测试结果通知
void callBackToSelf(EQueueMsgType& command);

//获取mmtp的init包信息，直接打出包来
std::string builder_init_package(uint64_t& linkId,bool& isBackground);

//打测速结果的pb包体
std::string build_speed_test_pb(SpeedTestResultBean &bean);

//收到init回包的处理
void InitRespReciev(void* threadObj,std::string Msg,std::string* mTag,std::string& clientip);

//收到了spanner的限流指令
void SpannerConstrainReciev(std::string Msg);
#endif
//收到了数据
void DataReciev(int channel,std::map<std::string,std::string> &head,const char* body,unsigned bodylen);
#ifdef USE_OLD_MNET
//收到zstd数据
void zstdRspReciev(const char* msg,unsigned msglen);

//收到zstderror数据
void zstdErrorReciev(const char* msg,unsigned msglen);

//收到了配置信息
void SettingReciev(const char* msg,unsigned msglen);

int ReconnectParserType(const char* msg,uint32_t msglen);

//收到了测速的iplist
void SpeedTestDestListPkgRcv(const char* msg,unsigned msglen);
#endif
//收到了命令包
void CmdListReciev(const char* msg, unsigned msglen);
#ifdef USE_OLD_MNET
//数据在队列中等待超时回调
void callBackWhenCommandTimeoutInQueue(void * threadObj,EQueueMsgType & command);

//查询网络状态
unsigned getAMNetAccessStatus();
#endif
//当出现错误时的回调
void callBackWhenError(bool isNetDomain,int errcode,std::string errmsg);
void noticeError(int errcode);

//设置当前接入点类型的接口
void setAccessPoint(void *threadObj);

//断网通知
void noticeNetDisconnectedORConnected(bool hasNet);

//mdap日志入口
void logWriteMdap(unsigned int level,std::string subType,const char* msg1,const char* msg2=NULL, const char* msg3=NULL,std::map<std::string,std::string> * msgMap = NULL);
//诊断日志入口
void diagnoseLog(std::string subType,const char* msg1,const char* msg2=NULL, const char* msg3=NULL,std::map<std::string,std::string> * msgMap = NULL);

//连接状态通知,状态类型参考MAAccess中的MAAccessStatus枚举型
void sendLinkStatusNotice(int status);
#ifdef USE_OLD_MNET
//切换网络时候的重连
void MainLoopReconnect();
#endif
//上报建连耗时
//void tcpConnectTimeCostReport(unsigned long tcp,unsigned long ssl,unsigned long total);
void tcpConnectTimeCostReport(std::map<std::string,std::string>& infomation);

//临时保存tcp connect info
void saveTcpConnectInfo(std::map<std::string,std::string>& infomation);
#ifdef USE_OLD_MNET
//处理消息回调
void sendDataAckReceived(unsigned long dataId,bool isTimeout,unsigned long tout);
#endif
//c层获取应用前后台状态
bool isAppForground();

//发送重登录请求给上层
void sendReLoginNotice();
#ifdef USE_OLD_MNET
//发送过的数据需要取消发送
void cancelSendedData(unsigned long dId);
#endif
//通知限流结束了
void noticeRestrictComplated();

//建连时候，查询建连的状态,1表示启动建连，2主动建连，3被动重连，4限流后重连
unsigned getReconnectType();
#ifdef USE_OLD_MNET
//被限流的时候，上次断链的原因填写
void setMainLoopReconnectRestrict();

//服务端状态包到来，目前只有请求免登的包，这个用来判断是不是这种包
bool parserStatusPkg(const char* data,unsigned len,bool& seqConfirmed,std::string& buf);

//服务器st状态包到来 判断是不是切前台的回包
//void parserStatusBack(const char* data,unsigned len,void *link);
#endif
//网络的连接状态，“连接中、连接完成、连接失败”，用来做日志等bool parserStatusPkg(const char* data,unsigned len,bool& seqConfirmed);
unsigned netStatusForOutAMNet();

//网络类型查询，主要是用来做日志等
std::string mobileNetType();
//从statusbar获取网络状态
void refreshStatusBar();
//埋点statusbar获取网络状态
int getStatusBarNetType();
//获取statusbar漫游信息
bool isStatusBarRoam();
std::string getStatusBarRoamInfo();
#ifdef USE_OLD_MNET
//当前有没有网络，用来做日志
bool mainLoopHasNet();
#endif
bool isVPNConnected();

#ifdef USE_OLD_MNET
//定时下次init时机，到时间时候一定要重发一次init
void setConstrainInitTimer(unsigned long msec);

std::vector<int> manualNetWorkCheckDoPing();
std::vector<int> manualNetworkCheckDoTraceroute();
void manualNetWorkCheckPingProgressNotify(int threadSeq, float pingProgress);//参数：ping过程进度0-1.f
void manualNetWorkCheckPingNotify(struct PingResult& res);
void manualNetworkCheckTracerouteProgressNotify(int threadSeq, float traceProgress);//参数：trace过程进度0-1.f
void manualNetworkCheckTracerouteNotify(struct TracerouteResult& res);

//构造mmtp头部分
std::string buildHeadPart(struct headInfomation& headInfo,bool &buildSucc);

//解析mmtp头部分
bool parserHeadPart(char* buf,unsigned len,struct headInfomation& headinfo);

//当用某一本地ip一直连不上时，需要注意查看是否是否需要用别的网卡的ip,如果没有其他本地ip了，返回false
bool getDifferentLocalEthIp(std::string &old,std::vector<std::string> &other,bool& isen0);

//当服务端的新seq下发下来时候，做sequence更新
void setNewServerSequence(int64_t seq,bool reSend = false);

//当前有没有mmtpseq的值，没有的话init需要去请求新的sequence
bool hasMMTPSeq();

uint64_t getUsingLonglink();

bool isUserSpecialAttention();

std::string buildRspCompensatePkg(std::map<unsigned long,RspCompensateInfo> & infos);
#endif
void noticePkgInfomationAfterRpcSendToTcp(uint64_t rpcid,int64_t dataHeadLen,int64_t payloadLen,int64_t totalLen);
#ifdef USE_OLD_MNET
//流量统计
void trafficStatistics(uint64_t channel,uint64_t pkgLen);

void noticeHttpChannelSwithOpenToSync(bool isOpen);
bool getShortChannelIsOpen();
#endif
//判断一个ip是不是v4的点分串
bool isIpAddressV4(std::string ipstr);

//刷新ipv6的填充头
void freshIpV6Prefix();

//将ipV4地址转成ipV6地址
bool getIpV6AddressFromIpV4(std::string v4,in6_addr& v6);

bool getIpV6StringAddressFromIpV4(std::string v4, std::string& v6);
#ifdef USE_OLD_MNET
void setDefaultNetCardIpV6Only(bool only);
#else
bool isDefaultNetCardIpV6Only();
#endif
std::string getIpV6AddressLocalDefaultNetCard(void*& addr);
#ifdef USE_OLD_MNET
//埋点上报tcpinfo信息
void noticeTcpInfo(std::map<std::string,std::string> tcpInfos);
#endif
void freshNewFunSwitch();
#ifdef USE_OLD_MNET
bool isIpAndDnsSwitchOpen();

bool isTcpInfoSwitchOpen();
#endif
bool isTreeStoreSwitchOpen();
#ifdef USE_OLD_MNET
bool isBuryPointSwitchOpen();

bool isStatusBarSwitchOpen();
#endif
//计算rpc的流量速率
void calculateTrafficSpeed(uint64_t dataid, double time);
//保存rpc流量值
void saveRpcTraffic(uint64_t dataId);

double getQoemodelRTO();

bool isQosLevelSwtichOpen();

#ifdef USE_OLD_MNET
bool isZstdSwtichOpen();
//获取zstdid
std::string getZstdDictionaryId();

//判断zstd字典是否在内存中
bool isZstdDictionaryInMemory(std::string zstdid);
//判断字典是否过期
bool isZstdExpiredById(std::string zstdid);

bool isTrafficSwtichOpen();

bool isABTestSwtichOpen();

bool isSfcPostiveHit();//短频是否正向命中

bool isScsPostiveHit();//短连接是否正向命中

bool isStcPostiveHit();//status是否正向命中

bool isSfcTestSwtichOpen();

bool isScsTestSwtichOpen();

bool isStcTestSwtichOpen();

bool isColdStartSwtichOpen();

uint64_t zstdRPCMaxSize();

std::string getUpTag();//上传的tag

bool isColdStartIn3s();//是否冷启动切在3s内
#endif
bool isBackgroundFetch();//是否后台不建连

bool isBackgroundFetchSwtichOpen();
#ifdef USE_OLD_MNET
bool isReportMsgSwtichOpen();

bool isMtlsErrorSwitchOpen();
#endif
/**是否打开统一库不降级开关*/
bool isOpenBifrostNoDowngradleSwitch();
#ifdef USE_OLD_MNET
bool threadBlockSwithOpen();

void cancelFetchStartConnect();
#endif
///////////////////////////////统一库相关接口/////////////////////////////////////
/**
 * 统一库开关
 */
bool isBifrostOpen();
/**
 * 提供给统一库收集init信息接口
 */
void collectInitInfo(BIFROST_collecting_t **value_0,size_t *count_0,BIFROST_gathering_t **value_1,size_t *count_1);
/**
 * init响应抛到上层
 */
void initResult(const BIFROST_init_rsp_t *inf);
/**
 * rpc超时响应抛到上层
 */
void dataSendingTimeout(long channel, const std::map<std::string,std::string> &head);

/**
 * rpc进度抛到上层
 */
void progressUpdate(long channel, long long receipt, long progress);
/**
 * app路径
 */
std::string getAppPath();
/**
 * utdid
 */
std::string getUtdid();

//国密回调函数，底层查看该host是否支持国密
//域名host是否支持国密双证书，lib_type为1表示STN，为2表示DTN
bool checkHostSupportUseGm(std::string host,int libType);
/**
 * app version
 */
unsigned int getAppVersion();
/**
 * userid 
 */
std::string getUserId();
/**
 * 统一库埋点上报
 */
void bifrostInfoReport(const std::map<std::string,std::string> &inf);
/**
 * 统一库发生致命错误
 */
void noticeFatalErrorHappen(std::string domain);

/**
 * 带memo的限流逻辑
 */
void restrictWithMemo(int delay,const char *inf);

///////////////////////////////统一库相关接口/////////////////////////////////////

bool useTTDOpen();

std::string syncSocketRequest(std::string host,uint16_t port,std::string data,int timeoutSec,int& errorCode,int& httpStat);

//获取当前时间, ms
uint64_t getNowTime();

//显示红条定时器
void startCanNotConnTimer();
//取消红条定时器
void stopCanNotConnTimer();
//设置网络状态
void setBifrostLinkStatus(int state);
//ping结果上报回调 canUse：是否ping通
#ifdef USE_OLD_MNET
void reportPingResult(bool canUse,std::string bizeName);
//crash改动开关
bool isCrashSwithOpen();
#endif
//#ifdef NEEDLOGSWITCH
//本地debug日志
int	 localDebug(FILE * , const char*,...);
//#endif

bool hasNotNet();
//spanner hpack error use spdy
void hpackErrUseSPDY();
//is fetch filter status
bool underFetchFilter();
//sessionid补偿逻辑
void needSessionIdComponsate();
#ifdef USE_OLD_MNET
bool eagainSwitch();

uint64_t eagainCount();

bool hpackLogSwitch();

bool timerDeleteSwitch();

bool needCheckQueueAfterLoop();

bool osVersionTooLow();
#endif
void registerAtExitCallback();

void onceRegisterAtExitCallback();

//---------------------------------------存储相关
void setStringKeyandNumberValueIntoDisk(std::string name,int64_t value);
bool getStringKeyNumberValueFromDisk(std::string name , int64_t& value);

void setStringKeyandStringValueIntoDisk(std::string name,std::string& value);
bool getStringKeyStringValueFromDisk(std::string name,std::string& value);

void setStringKeyandNumberVectorIntoDisk(std::string name,std::vector<unsigned>& value);
bool getStringKeyNumberVectorFromDisk(std::string name,std::vector<unsigned>& value);

void setStringKeyandStringVectorIntoDisk(std::string name,std::vector<std::string>& value);
bool getStringKeyStringVectorFromDisk(std::string name,std::vector<std::string>& value);

void setStringKeyandStringMapIntoDisk(std::string name,std::map<std::string,std::string>& value);
bool getStringKeyStringMapFromDisk(std::string name,std::map<std::string,std::string>& value);

void deleteStringKeyandStringValueFromDisk(std::string name);

void setStringKeyandNumberMapIntoDisk(std::string name,std::map<std::string,int64_t>& value);
bool getStringKeyNumberMapFromDisk(std::string name,std::map<std::string,int64_t>& value);

void setBifrostToDisk(std::string name,const void *val,size_t len);
void* getBifrostValueFromDisk(std::string name,size_t *len);

//big data save to file
void setBifrostToFile(const std::string& name, const void *val, size_t len, bool common);
void* getBifrostFromFile(const std::string& name, size_t *len, bool common);

char** getNewDnsByHost(const char* host,int* size);

char** getOnDemandDnsByHost(const char *host, int *size);

bool cleanNewDnsByHost(const char* host);

bool bindCellularPreCheck(const char* host, int fd, const int index);

void bindCellularResultNotify(bool result);

#endif
