//
//  MMTPFunStorage.h
//  AMNet
//
//  Created by feisong on 16/9/14.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface MMTPFunStorage : NSObject

@property(nonatomic, strong) NSString* uid;
#ifdef USE_OLD_MNET
@property(atomic,assign) BOOL isZstd;        //是否打开zstd功能 默认no
@property(atomic,assign) BOOL isIpAndDns;
@property(atomic,assign) BOOL isTcpInfo;
#endif
@property(atomic,assign) BOOL isTreeStore;
#ifdef USE_OLD_MNET
@property(atomic,assign) BOOL isBuryPoint;
#endif
@property(atomic,assign) BOOL isQosLevel;
#ifdef USE_OLD_MNET
@property(atomic,assign) BOOL isTraffic;
@property(atomic,assign) BOOL isABTest;
@property(atomic,assign) BOOL isColdStart;
#endif
@property(atomic,assign) BOOL isBackgroundFetch;
@property(atomic,assign) BOOL isReportMsg;
@property(atomic,assign) BOOL isUseExceptionView;//是否使用限流控件 默认yes
//不可用埋点的相关配置
@property(atomic,assign) BOOL useNotAvailbleLogic;  //是否开启不可用上报埋点
@property(atomic,assign) NSInteger notAvailbleDuration; //持续多久算不可用,单位秒
@property(atomic,assign) NSInteger notAvailbleCount;    //连续多少次算不可用
@property(atomic,assign) NSInteger massNotAvailbleDuration; //大数据通道持续多久算不可用,单位秒
@property(atomic,assign) NSInteger massNotAvailbleCount;    //大数据通道连续多少次算不可用
//是否使用statusbar获取相关信息埋点
#ifdef USE_OLD_MNET
@property(atomic,assign) BOOL useStatusBar;
#endif
@property(atomic,assign) BOOL massProxyTimerInMain;     //massproxy定时器线程使用主线程

@property(atomic,assign) BOOL aggressivFreshNetInterface;   //是否开启激进的刷网卡机制，在ipv6环境下频繁刷新网卡信息

@property(atomic,assign) BOOL isForgroundCompensate; //前台状态补偿
#ifdef USE_OLD_MNET
@property(atomic,assign) BOOL isMtlsError;//mtls埋点细化

@property(atomic,assign) NSInteger zstdRpcMaxSize;    //zstd rpc最大大小
#endif
@property(atomic,assign) BOOL ignoreNetStatus;//忽略网络状态

@property(atomic,assign) BOOL crashSwitchOpen;//crash修复

@property(atomic,assign) NSInteger hpackErrMaxCount;    //hpack解压失败降级的阈值

@property(atomic,assign) BOOL hpackSwitch;              //hpack解压失败降级功能开关

@property(atomic,assign) BOOL accountChange;              //before拦截器无登录态时发生账户切换抛异常功能
#ifdef USE_OLD_MNET
@property(atomic,assign) BOOL threadBlockSwitchOpen;       //  线程卡死开关
#endif
@property(atomic,assign) BOOL useTTD;           //是否使用ttd

/*******************************bifrost config***********************************/

@property(atomic,assign) NSInteger bDownPeriod;    //bifrost downgrade period 统一库 降级时长。单位秒，默认2小时

@property(atomic,assign) NSInteger bFailedRPCNum;  //bifrost failed rpc num 统一库 降级需要RPC连续失败次数。默认6次

@property(atomic,assign) NSInteger bIgnoreFailedRPCTime;    //bifrost ignore failed rpc time 统一库 RPC失败的连续时长判断，即多少毫秒内的错误数排除，单位:毫秒，默认100毫秒

@property(atomic,assign) NSInteger bActivateNum;    //bifrost activate num 统一库 一定时间内触发降级的启动amnet次数阈值，默认3次

@property(atomic,assign) NSInteger bActivateTime;    //bifrost activate time 统一库 一定时间内触发降级的启动amnet的时间阈值，默认30秒

/*******************************bifrost config***********************************/
@property(atomic,assign) BOOL relogin;           //2000重登陆问题开关
#ifdef USE_OLD_MNET
@property(atomic,assign) BOOL eagainSwitch;           //eagain防护开关

@property(atomic,assign) NSInteger eagainCount;           //eagain连续次数

@property(atomic,assign) BOOL hpackLog;           //hpack 详细日志开关

@property(atomic,assign) BOOL timerDeleteSwitch;           //timer定时器删除代码开关
#endif
@property(atomic,assign) BOOL defaultCardSwitch;           //默认网卡判断开关
#ifdef USE_OLD_MNET
@property(atomic,assign) BOOL tlsDiagnoseSwitch;            //tls诊断的开关控制
#endif
@property(atomic,assign) BOOL biforstDownNow;           //bifrost是否直接降级 默认否

@property(atomic,assign) BOOL loginFuseSwitch;          //是否登录熔断
#ifdef USE_OLD_MNET
@property(nonatomic, assign) BOOL checkQueueAfterLoop;      //事件循环结尾
#endif
@property(nonatomic, assign) BOOL bifrostMtlsSwitch;       //统一库mtls开关

@property(nonatomic, assign) BOOL netChangeFilter;       //统一库相同网络切换过滤

@property(nonatomic,assign) BOOL checkInWhiteList;      //白名单checkin

@property(nonatomic, assign) BOOL atexitSwitch;         //atexit注册开关

@property(nonatomic, assign) NSInteger delayRegisterAtexitTimeSec;  //延迟注册atexit秒数

@property(nonatomic, assign) BOOL regionInterceptorSwitch;

@property(nonatomic, assign) BOOL tsErrorInterceptorSwitch;

@property(atomic, assign) BOOL bifrostNoDowngradleSwitch;         //jm: 统一库不降级灰度开关

@property(nonatomic, assign) BOOL mgwEnvCntSwitch;                  //cnt网关生效开关

@property(nonatomic, assign) BOOL mgwEnvGmSwitch;                  //GM网关生效开关

@property(nonatomic, assign) BOOL alertInterceptorSwitch;         //无网提示拦截器

@property(nonatomic, assign) BOOL bindCellularSwitch;         //多网卡开关

@property(nonatomic, assign) BOOL cellularToastSwitch;        //多网卡toast开关

@property(nonatomic, assign) BOOL cellularForward;         //多网卡时机前置

@property(atomic,strong) NSArray *bindCellularHostList;       //多网卡域名列表

@property(nonatomic, assign) NSInteger alertThresholdSec;
/**
 * 获取单例
 */
+(instancetype)shareInstance;

/**
 * 从磁盘获取开关值
 */
-(NSDictionary*)getNewFunDictFromDisk;

/**
 * 存储开关值到磁盘
 */
-(void)storeNewFunDictToDisk:(NSDictionary*)dict;

//域名是否在指定列表中
-(BOOL)inBindCellularHostList:(NSString*)host;

@end
