//
//  MAStorageDelegate.h
//  Interface
//
//  Created by cuinacai on 15/3/27.
//  Copyright (c) 2015年 cuinacai. All rights reserved.
//
#import <Foundation/Foundation.h>

@protocol MAStorageDelegate <NSObject>
/**
 *	@brief	key-value的存储
 *
 *	@param 	value           存储值
 *  @param 	defaultName     key
 *
 *	@return 返回
 */

- (void)setObject:(id)value forKey:(NSString *)defaultName;
/**
 *	@brief	key根据获取value
 *
 *	@param 	defaultName     key
 *
 *	@return 返回value
 */
- (id)objectForKey:(NSString *)defaultName;
/**
 *	@brief	key根据删除存储的value
 *
 *	@param 	defaultName     key
 *
 *	@return 返回value
 */
- (void)removeObjectForKey:(NSString *)defaultName;
/**
 *	@brief	加密
 *
 *	@param 	加密前的数据
 *
 *	@return 返回加密后的数据
 */
- (NSData*)enCryptForData:(NSData *)enData;
/**
 *	@brief	解密
 *
 *	@param 	解密前的数据
 *
 *	@return 返回解密后的数据
 */
- (NSData*)DeCryptForData:(NSData *)deData;
@end

@protocol AMLogDelegate <NSObject>

/**
 *	@brief	打日志接口，
 *
 *	@param 	pfx ,sybType, content, 扩展字段，共四个item，第四个item是字典，字典内容可自定义，字典会被转换成key-value的字符串计入日志
 */
-(void)logwithSubType:(NSString*)pfx content:(NSArray*)content;
/**
 *	@brief	打日志接口，
 *
 *	@param 	sybType,扩展字段，第二个item是数组
 *
 */
-(void)writeLocalLogSubType:(NSString *) subType extraParams:(NSArray *) extraParams;

-(void)MTBIZ_Report:(NSString*)bizName subName:(NSString*)subName failCode:(NSInteger)failCode params:(NSDictionary*)params;
/**
 *	@brief	打日志接口，
 *
 *	@param 	pfx ,sybType, content, 扩展字段，共四个item，第四个item是字典，字典内容可自定义，字典会被转换成key-value的字符串计入日志
 */
//-(void)logwithFootprintLogParam1:(NSString*)param1 param2:(NSString *)param2 param3:(NSString *)param3 paramKVMap:(NSDictionary *)map;
@end


