//
//  DemoViewController.m
//  test
//
//  Created by mPaaS on 16/11/21.
//  Copyright © 2016年 Alibaba. All rights reserved.
//

#import "DemoViewController.h"

@interface DemoViewController ()

@end

@implementation DemoViewController

- (NSArray *)dataList
{
    return @[
        @{@"name":@"移动网关服务", @"class":@"MPRPCViewController"},
        @{@"name":@"实时发布服务", @"class":@"MPMDSViewController"},
        @{@"name":@"H5容器和离线包", @"class":@"MPH5NebulaAppViewController"},
        @{@"name":@"小程序", @"class":@"MPMiniProgramViewController"},
        @{@"name":@"移动分析", @"class":@"MP_AnalysisViewController"},
        @{@"name":@"终端环境检测", @"class":@"MPSecurityViewController"},
        @{@"name":@"AB实验室", @"class":@"MPABViewController"},
        ];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    // 通知 Launcher 已经展示
    [[NSNotificationCenter defaultCenter] postNotificationName:@"kNotificationLauncherDidAppear"
    object:nil];
    
    CREATE_UI({
        BUTTON_WITH_ACTION(NSLocalizedString(@"移动网关 Mobile Gat eway Service", nil), buttonClicked0)
        BUTTON_WITH_ACTION(NSLocalizedString(@"移动发布 Mobile Delivery Service", nil), buttonClicked1)
        BUTTON_WITH_ACTION(NSLocalizedString(@"H5容器和离线包 H5NebulaApp", nil), buttonClicked2)
        BUTTON_WITH_ACTION(NSLocalizedString(@"小程序 MiniProgram", nil), buttonClicked3)
        BUTTON_WITH_ACTION(NSLocalizedString(@"移动分析 Mobile Analysis Service", nil), buttonClicked4)

        BUTTON_WITH_ACTION(NSLocalizedString(@"终端环境检测 Mobile Environment Detection", nil), buttonClicked5)
        BUTTON_WITH_ACTION(NSLocalizedString(@"AB实验室", nil), buttonClicked6)


    })
}
-(void)buttonClicked0{
    [self buttonClicked:0];
}
-(void)buttonClicked1{
    [self buttonClicked:1];
}
-(void)buttonClicked2{
    [self buttonClicked:2];
}

-(void)buttonClicked3{
    [self buttonClicked:3];
}
-(void)buttonClicked4{
    [self buttonClicked:4];
}
-(void)buttonClicked5{
    [self buttonClicked:5];
}
-(void)buttonClicked6{
    [self buttonClicked:6];
}

-(void)buttonClicked:(NSInteger )index{
    
    NSDictionary *dic = [self dataList][index];
    NSString *className = dic[@"class"];
    if (className.length) {
        Class cls = NSClassFromString(className);
        id vc = [[cls alloc] init];
        if ([vc isKindOfClass:UIViewController.class]) {
            [self.navigationController pushViewController:vc animated:YES];
        }
    }else{
        NSLog(@"没找到对应控制器");
    }
}




@end
