#/usr/bin/python
import sys
import os

def split_stream(stream_sql_file, outputdir):
  (filepath,tempfilename) = os.path.split(stream_sql_file)
  (filename,extension) = os.path.splitext(tempfilename)
  stream_fd = open(stream_sql_file, 'r')
  lines = stream_fd.readlines()
  file_count=0
  for line in lines:
      if line.strip().startswith("ID =") or 'Query cost time:' in line.strip():
          file_count += 1
  if file_count < 2:
      return
  file_name = os.path.basename(filename)+"_1.err"
  output_fd = open(outputdir + file_name, 'w')
  count = 1
  firstCost = 1

  for line in lines:
    print line
    print "filename"+file_name
    print "count:"+str(count)
    if line.strip().startswith("ID =") or 'Query cost time:' in line.strip():
        if line.strip().startswith("ID =") and count > 0 :
            output_fd.write("start,2019-05-22 23:33:57.95,end,2019-05-22 23:33:57.95,cost,1"+"\n")
        if 'Query cost time:' in line.strip():
            #firstCost = "{:.2f}".format(float(line.strip().split(' ')[3])/1000.0)
            firstCost = "{:.2f}".format(float(line.strip().split(' ')[3]))
            output_fd.write(line)
            output_fd.write("start,2019-05-22 23:33:57.95,end,2019-05-22 23:33:57.95,cost,"+firstCost+"\n")
        count += 1
        if count < file_count + 1:
            print "new file"
            output_fd.close()
            print "count:"+str(count)
            file_name=os.path.basename(filename)+"_"+str(count)+".err"
            print "new file name:"+file_name
            output_fd = open(outputdir + file_name, 'w')
        else:
            break
    if line.strip().startswith("OK"):
        continue
    if not 'Query cost time:' in line.strip():
        output_fd.write(line)

  if output_fd:
    output_fd.close()

if __name__ == '__main__':
  if len(sys.argv) != 3:
    print "error param, python split.py [stream_sql_file] [outputdir]"
    sys.exit(1)
  stream_sql_file = sys.argv[1]
  output_dir = sys.argv[2]
  if os.path.isfile(output_dir):
    print 'output_dir:%s is a file' % output_dir
    sys.exit(1)
  if not os.path.exists(output_dir):
    os.makedirs(output_dir)
  if not os.path.isfile(stream_sql_file):
    print 'stream_sql_file:%s is not a file' % stream_sql_file
    sys.exit(1)
  split_stream(stream_sql_file, output_dir)
  os.remove(stream_sql_file)
