#!/bin/bash
set -x
source ../config
case_set=$1
path=$2
query_path=$3
report_dir_name=$4
report_name=$5
report_root_dir=$(cd `dirname $0`; pwd)
if [ $# != 4 ];then
    echo "$0 case_set(tpcds/tpch) result_path query_path report_dir_name report_name"
echo "p1:case_set :e.g. tpcds or tpch"
echo "p2:result_path : e.g. /home/admin/huina.lhn/tpcds/benchmark/logs/stream_0/"
echo "p3:query_path : e.g. /home/admin/huina.lhn/tpcds/benchmark/queries/stream_0/"
echo "p4:report_dir_name : e.g. stream_0"
exit 1
fi

source ${path}/config
cd $report_root_dir
result_dir=${report_dir_name}"_"`date "+%Y%m%d%H%M%S"`
mkdir -p $result_dir
for i in `ls $path/ |grep .err`
do
cp $path/$i $result_dir/"tpcds_${SF}."$i
done
for i in `ls $result_dir`
do
count=`grep http $result_dir/$i |wc |awk '{print $1}'`
if [ $count -eq 2 ]
then
python split.py $result_dir/$i $result_dir/
echo $i
fi
done
mkdir -p $result_dir/query
mkdir -p $result_dir/query_out
mkdir -p $result_dir/logview
cp -rf $path/query_running_log $result_dir/
cp $path/query*.out $result_dir/query_out/
for query_name in `ls ${query_path} |grep query |awk -F '.' '{print $1}'`
do
query_name_new=`head -n 1 ${query_path}/${query_name}.sql |awk '{print $NF}' |awk -F '.' '{print $1}'`
#query_name=$i
cp ${query_path}/${query_name}.sql $result_dir/query/${query_name_new}.txt
done

cp -f ${path}/config ${result_dir}/query/
cp ${path}/../${report_dir_name}_timeing.log $result_dir

for i in `ls $result_dir/ |grep .err`
do
query_name=`echo $i |awk -F '.' '{print $2}'`
#echo "${query_name} "`grep "ID =" $result_dir/$i | awk '{print $3}'` >> $result_dir/queryname_instanceid.list
query_logview=`grep http[s]*://logview ${result_dir}/$i | head -n 1 | cut -b "9-"`
instanceid=`echo "${query_logview}"| awk -F '&i=' '{print $2}' |awk -F '&' '{print $1}'`
echo "${query_name} ${instanceid}" >> $result_dir/queryname_instanceid.list
#curl -d '{"logviewUrls": "'${query_logview}'"}' -H 'Content-Type: application/json' http://odps.alibaba.net:8888/studio-service/getOfflineLogviewFile --output $result_dir/logview/${i}.logview;
#logview_download_url=`echo "${query_logview}" |sed -e 's#http[s]*://logview.alibaba-inc.com/logview/#https://logview.alibaba-inc.com/getOfflineLogviewFile#g'|sed -e 's#http[s]*://logview.aliyun.com/logview/#https://logview.alibaba-inc.com/getOfflineLogviewFile#g'|sed -e 's#http[s]*://logview.odps.aliyun.com/logview/#https://logview.alibaba-inc.com/getOfflineLogviewFile#g'`
#echo $logview_download_url
#curl "${logview_download_url} " --output $result_dir/logview/${i}.logview.new;
#if [ "${MODE}"x == "session"x ]
#then
logview_download_url=`echo "${query_logview}" |sed -e 's#http[s]*://logview.alibaba-inc.com/logview/#https://logview.alibaba-inc.com/getOfflineLogviewFile#g'|sed -e 's#http[s]*://logview.aliyun.com/logview/#https://logview.alibaba-inc.com/getOfflineLogviewFile#g'|sed -e 's#http[s]*://logview.odps.aliyun.com/logview/#https://logview.alibaba-inc.com/getOfflineLogviewFile#g'`
echo $logview_download_url
curl "${logview_download_url} " --output $result_dir/logview/${i}.logview.new;
#else
#curl -d '{"logviewUrls": "'${query_logview}'"}' -H 'Content-Type: application/json' http://odps.alibaba.net:8888/studio-service/getOfflineLogviewFile --output $result_dir/logview/${i}.logview;
#fi
done


#生成报告
if [[ -n ${GEN_REPORT} ]] && [[ "${GEN_REPORT}"x == "true"x ]]
then
    sh  ${report_root_dir}/perf-analyze-dist/bin/runAnalyze.sh ${report_root_dir}/${result_dir} 'false true'
    >$result_dir/query_cost.txt
    for i in `seq 1 99`;do grep "query$i start" ${path}/../${report_dir_name}_timeing.log |awk -F ',' '{print $NF}' |awk '{print $1}' >> $result_dir/query_cost.txt;done
fi

cp ${path}/../${report_dir_name}_timeing.log $result_dir
cd ${result_dir}
grep "Job run time" *.err| awk -F ':' '{print $1,$3}' | sed 's/tpcds_10t.//g' | sed 's/.err//g' | sed 's/_\w//g' | awk '{ arr[$1]+=$2 } END { for (key in arr) print key, arr[key] }' | sed 's/query//g'|sort -n | awk '{print $2}' > runtime_cost.txt
cp -f ${path}/config ./query/

if [ "${MODE}"x != "session"x ]
then
mkdir -p summary
cat queryname_instanceid.list | while read i; do query=`echo $i | awk '{print $1}'`; inst=`echo $i | awk '{print $2}'`;${ODPS_CLT_CMD} --project=${PROJECT} -e "use quota ${MCQA2_QUOTA_NAME}; wait $inst;" > summary/$query 2>&1; done;
else
    for filename in `ls |grep .err`
    do
        cpname=`echo $filename | awk -F '.' '{print $2}'`
        cp $filename ./summary/${cpname}
    done
fi


if [[ -n ${GEN_REPORT} ]] && [[ "${GEN_REPORT}"x == "true"x ]]
then
    for i in `ls summary`
    do
        echo $i
        query_logview=`grep http[s]*://logview summary/$i`
        grep '&subQuery=' summary/$i
        is_summary=$?
        grep 'Summary:' summary/$i
        has_summary_ret_code=$?

        if [[ "${query_logview}"x != ""x  ]] && [[ ${is_subquery} -eq 0  ]] && [[ ${has_summary_ret_code} != 0  ]]
        then
            mv summary/$i summary/${i}.bak
            sh  ${report_root_dir}/perf-analyze-dist/bin/runGetSessionSummaryFromLogview.sh "${query_logview}" > summary/$i
        fi
    done
    for filename in `ls |grep .err`
    do

        sed -i '/http:\/\/logview/i Log view:' $filename
        sed -i '/https:\/\/logview/i Log view:' $filename
        sed -i 's#^.*http://logview#http://logview#g' $filename
        sed -i 's#^.*https://logview#https://logview#g' $filename

    done
    /home/admin/jenkins/perf_tools/current/perf-analyze-dist/bin/runAnalyze.sh ${report_root_dir}/${result_dir} 'true true' 'true'
fi

grep "Job run time" summary/query*| awk -F ':' '{print $1,$3}' | sed 's#summary/##g' | sed 's/_\w//g' | awk '{ arr[$1]+=$2 } END { for (key in arr) print key, arr[key] }' | sed 's/query//g'|sort -n | awk '{print $2}' > runtime_cost.txt

sh ../getmode.sh $result_dir
