-- start query 47 in stream 0 using template query35.tpl
select   
  ca_state,
  cd_gender,
  cd_marital_status,
  cd_dep_count,
  count(*) cnt1,
  min(cd_dep_count),
  avg(cd_dep_count),
  min(cd_dep_count),
  cd_dep_employed_count,
  count(*) cnt2,
  min(cd_dep_employed_count),
  avg(cd_dep_employed_count),
  min(cd_dep_employed_count),
  cd_dep_college_count,
  count(*) cnt3,
  min(cd_dep_college_count),
  avg(cd_dep_college_count),
  min(cd_dep_college_count)
 from
  bigdata_public_dataset.tpcds_10t.customer c,bigdata_public_dataset.tpcds_10t.customer_address ca,bigdata_public_dataset.tpcds_10t.customer_demographics
 where
  c.c_current_addr_sk = ca.ca_address_sk and
  cd_demo_sk = c.c_current_cdemo_sk and 
  exists (select *
          from bigdata_public_dataset.tpcds_10t.store_sales,bigdata_public_dataset.tpcds_10t.date_dim
          where c.c_customer_sk = ss_customer_sk and
                ss_sold_date_sk = d_date_sk and
                d_year = 2000 and
                d_qoy < 4) and
   (exists (select *
            from bigdata_public_dataset.tpcds_10t.web_sales,bigdata_public_dataset.tpcds_10t.date_dim
            where c.c_customer_sk = ws_bill_customer_sk and
                  ws_sold_date_sk = d_date_sk and
                  d_year = 2000 and
                  d_qoy < 4) or 
    exists (select * 
            from bigdata_public_dataset.tpcds_10t.catalog_sales,bigdata_public_dataset.tpcds_10t.date_dim
            where c.c_customer_sk = cs_ship_customer_sk and
                  cs_sold_date_sk = d_date_sk and
                  d_year = 2000 and
                  d_qoy < 4))
 group by ca_state,
          cd_gender,
          cd_marital_status,
          cd_dep_count,
          cd_dep_employed_count,
          cd_dep_college_count
 order by ca_state,
          cd_gender,
          cd_marital_status,
          cd_dep_count,
          cd_dep_employed_count,
          cd_dep_college_count
 limit 100;

-- end query 47 in stream 0 using template query35.tpl
