-- start query 64 in stream 0 using template query12.tpl
select  i_item_id
      ,i_item_desc 
      ,i_category 
      ,i_class 
      ,i_current_price
      ,sum(ws_ext_sales_price) as itemrevenue 
      ,sum(ws_ext_sales_price)*100/sum(sum(ws_ext_sales_price)) over
          (partition by i_class) as revenueratio
from	
	bigdata_public_dataset.tpcds_100g.web_sales
    	,bigdata_public_dataset.tpcds_100g.item 
    	,bigdata_public_dataset.tpcds_100g.date_dim
where 
	ws_item_sk = i_item_sk 
  	and i_category in ('Jewelry', 'Electronics', 'Children')
  	and ws_sold_date_sk = d_date_sk
	and d_date between cast('2000-03-25' as date) 
				and (cast('2000-03-25' as date) + interval '30' day)
group by 
	i_item_id
        ,i_item_desc 
        ,i_category
        ,i_class
        ,i_current_price
order by 
	i_category
        ,i_class
        ,i_item_id
        ,i_item_desc
        ,revenueratio
limit 100;

-- end query 64 in stream 0 using template query12.tpl
