-- start query 44 in stream 0 using template query92.tpl
select  
   sum(ws_ext_discount_amt)  as `Excess Discount Amount` 
from 
    bigdata_public_dataset.tpcds_100g.web_sales 
   ,bigdata_public_dataset.tpcds_100g.item 
   ,bigdata_public_dataset.tpcds_100g.date_dim
where
i_manufact_id = 168
and i_item_sk = ws_item_sk 
and d_date between '2000-02-22' and 
        (cast('2000-02-22' as date) + interval '90' day)
and d_date_sk = ws_sold_date_sk 
and ws_ext_discount_amt  
     > ( 
         SELECT 
            1.3 * avg(ws_ext_discount_amt) 
         FROM 
            bigdata_public_dataset.tpcds_100g.web_sales 
           ,bigdata_public_dataset.tpcds_100g.date_dim
         WHERE 
              ws_item_sk = i_item_sk 
          and d_date between '2000-02-22' and
                             (cast('2000-02-22' as date) + interval '90' day)
          and d_date_sk = ws_sold_date_sk 
      ) 
order by sum(ws_ext_discount_amt)
limit 100;

-- end query 44 in stream 0 using template query92.tpl
