#!/bin/bash
set -e
set -x
source ./config
WORK_DIR=$(cd `dirname $0`; pwd)

echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` , build dsdgen start"
rm -rf ${TOOLS_VERSION}
unzip 1c7039e3-2a1d-451b-bfda-d14c49016243-tpc-ds-tool.zip
cat patches/tool-printc.diff | patch -p1 -d ./
cat patches/tool-no-return-data.diff | patch -p1 -d ./
cd ${WORK_DIR}/${TOOLS_VERSION}/tools;make clean;make
cp -f tpcds.idx ${WORK_DIR}/tools_file/
cp -f dsdgen ${WORK_DIR}/tools_file/
echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` , build dsdgen end"

echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` , build dsdgen_return start"
cd ${WORK_DIR}
rm -rf ${TOOLS_VERSION}
unzip 1c7039e3-2a1d-451b-bfda-d14c49016243-tpc-ds-tool.zip
cat patches/tool-printc.diff | patch -p1 -d ./
cat patches/tool-only-return-data.diff | patch -p1 -d ./
cd ${WORK_DIR}/${TOOLS_VERSION}/tools;make clean;make
cp -f dsdgen ${WORK_DIR}/tools_file/dsdgen_return
echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` , build dsdgen_return end"

echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` , unzip tool.zip start"
cd ${WORK_DIR}
rm -rf ${TOOLS_VERSION}
unzip 1c7039e3-2a1d-451b-bfda-d14c49016243-tpc-ds-tool.zip
echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` , unzip tool.zip end"

# Copy from offical toolset, apply patches, build dsqgen
# apply patches
cat patches/e.1-delimited-identifiers.diff | patch -p1 -d ./
cat patches/f.1-date-expression.diff | patch -p1 -d ./
cat patches/g.3-ordinals.diff | patch -p1 -d ./
cat patches/e.4-nested-table-expression-aliasing.diff | patch -p1 -d ./
cat patches/g.2-parentheses.diff | patch -p1 -d ./
cat patches/maxcomputesql-dialect.diff | patch -p1 -d ./
#cat $bin/patches/dialect/*.diff | patch -p1 -d ${BUILD_DIR}/${TOOLS_VERSION}/query_templates
echo "${TOOLS_VERSION}"
cd ${WORK_DIR}/${TOOLS_VERSION}/tools;make clean; make dsqgen
cd ${WORK_DIR}/${TOOLS_VERSION}/tools;make dsdgen

echo "At `date '+%Y-%m-%d %H:%M:%S.%2N'` , Initialization finished." | tee -a $LOG 2>&1
