/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.impl;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.impl.Util;
import com.aliyun.odps.tunnel.io.TunnelRetryHandler;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SessionBase {
    protected String id;
    protected Configuration config;
    protected String projectName;
    protected String schemaName;
    protected String tableName;
    protected String partitionSpec;
    protected String quotaName;
    protected RestClient httpClient;
    protected TableSchema schema = new TableSchema();
    protected TunnelRetryHandler tunnelRetryHandler = new TunnelRetryHandler();

    protected abstract String getResource();

    protected HttpResult httpRequestWithNoRetry(HashMap<String, String> headers, Map<String, String> params, String method, String action) throws TunnelException {
        String requestId = null;
        Connection conn = null;
        try {
            conn = this.httpClient.connect(this.getResource(), method, params, headers);
            Response resp = conn.getResponse();
            requestId = resp.getHeader("x-odps-request-id");
            if (resp.isOK()) {
                HttpResult httpResult = new HttpResult(requestId, resp.getStatus(), IOUtils.readStreamAsString(conn.getInputStream()));
                return httpResult;
            }
            try {
                throw new TunnelException(requestId, conn.getInputStream(), resp.getStatus());
            }
            catch (IOException e) {
                throw new TunnelException(requestId, "Failed to " + action + " with tunnel endpoint " + this.httpClient.getEndpoint(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(requestId, e.getMessage(), e);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected HttpResult httpRequest(HashMap<String, String> headers, Map<String, String> params, String method, String action) throws TunnelException {
        try {
            return this.tunnelRetryHandler.executeWithRetry(() -> this.httpRequestWithNoRetry(headers, params, method, action));
        }
        catch (TunnelException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    protected HashMap<String, String> getCommonHeaders() {
        HashMap<String, String> commonHeaders = Util.getCommonHeader();
        List<String> tags = this.config.getTags();
        if (tags != null) {
            commonHeaders.put("odps-tunnel-tags", String.join((CharSequence)",", tags));
        }
        return commonHeaders;
    }

    protected HashMap<String, String> getCommonParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
            params.put("partition", this.partitionSpec);
        }
        if (!StringUtils.isNullOrEmpty((String)this.config.getQuotaName())) {
            params.put("quotaName", this.config.getQuotaName());
        }
        return params;
    }

    public TunnelRetryHandler getTunnelRetryHandler() {
        return this.tunnelRetryHandler;
    }

    public class HttpResult {
        public String requestId;
        public Integer status;
        public String body;

        HttpResult(String requestId, Integer status, String body) {
            this.requestId = requestId;
            this.status = status;
            this.body = body;
        }
    }
}

