/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.google.gson.GsonBuilder;
import java.util.Map;

@Root(name="LOT", strict=false)
public class LOTTask
extends Task {
    @Element(name="Plan", required=false)
    private Plan plan;
    @Element(name="Query", required=false)
    private String query;

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public static Instance run(Odps odps, String input, boolean runSQL) throws OdpsException {
        String project = odps.getDefaultProject();
        if (project == null) {
            throw new OdpsException("default project required.");
        }
        return LOTTask.run(odps, project, input, runSQL, "AnonymousLOTTask", null, null);
    }

    public static Instance run(Odps odps, String project, String input, boolean runSQL, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return LOTTask.run(odps, project, input, runSQL, "AnonymousLOTTask", hints, aliases);
    }

    public static Instance run(Odps odps, String project, String input, boolean runSQL, String taskName, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        String json;
        LOTTask task = new LOTTask();
        if (runSQL) {
            task.setQuery(input);
        } else {
            Plan plan = new Plan();
            plan.setResourceName(input);
            plan.setProject(project);
            task.setPlan(plan);
        }
        task.setName(taskName);
        if (hints != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (aliases != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return odps.instances().create(project, task);
    }

    @Root(name="plan", strict=false)
    public static class Plan {
        @Element(name="ResourceName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String resourceName;
        @Element(name="Project", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String project;

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public String getProject() {
            return this.project;
        }
    }
}

