/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.accessor;

import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.accessor.ArrowStructAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowVectorAccessor;
import com.aliyun.odps.table.record.accessor.ArrowToRecordConverter;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.complex.StructVector;

public class ArrowStructAccessorImpl {

    public static class ArrowStructAccessorForRecord
    extends ArrowStructAccessor<Struct> {
        private final boolean isExtension;
        private final ArrowVectorAccessor[] childAccessors;
        private final TypeInfo structTypeInfo;
        private final List<TypeInfo> childTypeInfos;

        public ArrowStructAccessorForRecord(StructVector structVector, TypeInfo typeInfo, boolean isExtension) {
            super(structVector);
            this.isExtension = isExtension;
            this.structTypeInfo = typeInfo;
            this.childTypeInfos = ((StructTypeInfo)typeInfo).getFieldTypeInfos();
            this.childAccessors = new ArrowVectorAccessor[structVector.size()];
            for (int i = 0; i < this.childAccessors.length; ++i) {
                this.childAccessors[i] = ArrowToRecordConverter.createColumnVectorAccessor(structVector.getVectorById(i), this.childTypeInfos.get(i), isExtension);
            }
        }

        @Override
        public Struct getStruct(int rowId) {
            ArrayList<Object> values = new ArrayList<Object>();
            try {
                for (int i = 0; i < this.childAccessors.length; ++i) {
                    values.add(ArrowToRecordConverter.getData(this.childAccessors[i], this.childTypeInfos.get(i), rowId, this.isExtension));
                }
                return new SimpleStruct((StructTypeInfo)this.structTypeInfo, values);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get the struct", e);
            }
        }
    }
}

