/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableFilter;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.GenerateExpression;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.table.utils.Preconditions;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.aliyun.odps.utils.CommonUtils;
import com.aliyun.odps.utils.ExceptionUtils;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Tables
implements Iterable<Table> {
    private RestClient client;
    private Odps odps;

    Tables(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Table get(String tableName) {
        return this.get(this.getDefaultProjectName(), tableName);
    }

    public Table get(String projectName, String tableName) {
        return this.get(projectName, this.odps.getCurrentSchema(), tableName);
    }

    public Table get(String projectName, String schemaName, String tableName) {
        Table.TableModel model = new Table.TableModel();
        model.name = tableName;
        return new Table(model, projectName, schemaName, this.odps);
    }

    public boolean exists(String tableName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), tableName);
    }

    public boolean exists(String projectName, String tableName) throws OdpsException {
        return this.exists(projectName, this.odps.getCurrentSchema(), tableName);
    }

    public boolean exists(String projectName, String schemaName, String tableName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)tableName)) {
            return false;
        }
        try {
            Table t = this.get(projectName, schemaName, tableName);
            t.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public Iterator<Table> iterator() {
        return this.iterator(this.getDefaultProjectName(), null);
    }

    public Iterator<Table> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    public Iterator<Table> iterator(TableFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    public Iterator<Table> iterator(String projectName, TableFilter filter) {
        return this.iterator(projectName, filter, false);
    }

    public Iterator<Table> iterator(String projectName, TableFilter filter, boolean extended) {
        return new TableListIterator(projectName, this.odps.getCurrentSchema(), filter, extended);
    }

    public Iterator<Table> iterator(String projectName, String schemaName, TableFilter filter, boolean extended) {
        return new TableListIterator(projectName, schemaName, filter, extended);
    }

    public Iterable<Table> iterable() {
        return this.iterable(this.getDefaultProjectName());
    }

    public Iterable<Table> iterable(String projectName) {
        return this.iterable(projectName, null);
    }

    public Iterable<Table> iterable(TableFilter filter) {
        return this.iterable(this.getDefaultProjectName(), filter);
    }

    public Iterable<Table> iterable(String projectName, TableFilter filter) {
        return this.iterable(projectName, filter, false);
    }

    public Iterable<Table> iterable(String projectName, TableFilter filter, boolean extended) {
        return this.iterable(projectName, this.odps.getCurrentSchema(), filter, extended);
    }

    public Iterable<Table> iterable(String projectName, String schemaName, TableFilter filter, boolean extended) {
        return () -> new TableListIterator(projectName, schemaName, filter, extended);
    }

    public void create(String tableName, TableSchema schema) throws OdpsException {
        this.create(this.client.getDefaultProject(), tableName, schema);
    }

    public void create(String tableName, TableSchema schema, boolean ifNotExists) throws OdpsException {
        this.create(this.client.getDefaultProject(), tableName, schema, ifNotExists);
    }

    public void create(String projectName, String tableName, TableSchema schema, boolean ifNotExists, Long shardNum, Long hubLifecycle) throws OdpsException {
        this.create(projectName, tableName, schema, null, ifNotExists, shardNum, hubLifecycle);
    }

    public void create(String projectName, String tableName, TableSchema schema) throws OdpsException {
        this.create(projectName, tableName, schema, false);
    }

    public void create(String projectName, String tableName, TableSchema schema, boolean ifNotExists) throws OdpsException {
        this.create(projectName, tableName, schema, null, ifNotExists);
    }

    public void create(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long shardNum, Long hubLifecycle) throws OdpsException {
        DataHubInfo dataHubInfo = new DataHubInfo(shardNum, hubLifecycle);
        TableCreator tableCreator = this.newTableCreator(projectName, tableName, schema).withSchemaName(this.odps.getCurrentSchema()).withComment(comment).withDataHubInfo(dataHubInfo);
        if (ifNotExists) {
            tableCreator = tableCreator.ifNotExists();
        }
        tableCreator.create();
    }

    public void create(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists) throws OdpsException {
        this.createTableWithLifeCycle(projectName, tableName, schema, comment, ifNotExists, null);
    }

    public void createTableWithLifeCycle(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle) throws OdpsException {
        this.create(projectName, tableName, schema, comment, ifNotExists, lifeCycle, null, null);
    }

    public void create(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        this.create(projectName, this.odps.getCurrentSchema(), tableName, schema, comment, ifNotExists, lifeCycle, hints, aliases);
    }

    public void create(String projectName, String schemaName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        TableCreator tableCreator = this.newTableCreator(projectName, tableName, schema).withSchemaName(schemaName).withComment(comment).withLifeCycle(lifeCycle).withHints(hints).withAliases(aliases);
        if (ifNotExists) {
            tableCreator = tableCreator.ifNotExists();
        }
        tableCreator.create();
    }

    public void createExternal(String projectName, String tableName, TableSchema schema, String location, String storedBy, List<String> usingJars, Map<String, String> serdeProperties, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        this.createExternal(projectName, this.odps.getCurrentSchema(), tableName, schema, location, storedBy, usingJars, serdeProperties, comment, ifNotExists, lifeCycle, hints, aliases);
    }

    public void createExternal(String projectName, String schemaName, String tableName, TableSchema schema, String location, String storedBy, List<String> usingJars, Map<String, String> serdeProperties, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        TableCreator tableCreator = this.newTableCreator(projectName, tableName, schema).externalTable().withSchemaName(schemaName).withStorageHandler(storedBy).withResources(usingJars).withLocation(location).withSerdeProperties(serdeProperties).withComment(comment).withLifeCycle(lifeCycle).withHints(hints).withAliases(aliases);
        if (ifNotExists) {
            tableCreator = tableCreator.ifNotExists();
        }
        tableCreator.create();
    }

    public void delete(String tableName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), tableName);
    }

    public void delete(String tableName, boolean ifExists) throws OdpsException {
        this.delete(this.client.getDefaultProject(), tableName, ifExists);
    }

    public void delete(String projectName, String tableName) throws OdpsException {
        this.delete(projectName, tableName, false);
    }

    public void delete(String projectName, String tableName, boolean ifExists) throws OdpsException {
        this.delete(projectName, this.odps.getCurrentSchema(), tableName, ifExists);
    }

    public void delete(String projectName, String schemaName, String tableName, boolean ifExists) throws OdpsException {
        if (projectName == null || tableName == null) {
            throw new IllegalArgumentException("Argument 'projectName' or 'tableName' cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE ");
        if (ifExists) {
            sb.append(" IF EXISTS ");
        }
        sb.append(NameSpaceSchemaUtils.getFullName(projectName, schemaName, tableName));
        sb.append(";");
        String taskName = "SQLDropTableTask";
        SQLTask task = new SQLTask();
        task.setName(taskName);
        task.setQuery(sb.toString());
        this.submitCreateAndWait(schemaName, sb.toString(), "SQLDropTableTask", null, null);
    }

    public List<Table> loadTables(Collection<String> tableNames) throws OdpsException {
        return this.loadTables(this.getDefaultProjectName(), tableNames);
    }

    public List<Table> loadTables(String projectName, Collection<String> tableNames) throws OdpsException {
        return this.loadTables(projectName, this.odps.getCurrentSchema(), tableNames);
    }

    public List<Table> loadTables(String projectName, String schemaName, Collection<String> tableNames) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Invalid project name.");
        }
        if (tableNames == null) {
            throw new IllegalArgumentException("Invalid table names.");
        }
        QueryTables queryTables = new QueryTables();
        for (String name : tableNames) {
            queryTables.tables.add(new QueryTables.QueryTable(projectName, schemaName, name));
        }
        return this.loadTablesInternal(queryTables);
    }

    public List<Table> reloadTables(Collection<Table> tables) throws OdpsException {
        if (tables == null) {
            throw new IllegalArgumentException("Invalid tables.");
        }
        return this.reloadTables(tables.iterator());
    }

    public List<Table> reloadTables(Iterator<Table> tables) throws OdpsException {
        if (tables == null) {
            throw new IllegalArgumentException("Invalid tables.");
        }
        ArrayList<Table> loadedTables = new ArrayList<Table>();
        if (!tables.hasNext()) {
            return loadedTables;
        }
        QueryTables queryTables = new QueryTables();
        while (tables.hasNext()) {
            Table t = tables.next();
            if (t.isLoaded()) {
                loadedTables.add(t);
                continue;
            }
            queryTables.tables.add(new QueryTables.QueryTable(t.getProject(), t.getSchemaName(), t.getName()));
        }
        if (!queryTables.tables.isEmpty()) {
            loadedTables.addAll(this.loadTablesInternal(queryTables));
        }
        return loadedTables;
    }

    private List<Table> loadTablesInternal(QueryTables queryTables) throws OdpsException {
        ArrayList<Table> reloadTables = new ArrayList<Table>();
        if (queryTables.tables.isEmpty()) {
            return reloadTables;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", null);
        String resource = ResourceBuilder.buildTablesResource(this.getDefaultProjectName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(queryTables);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        ListTablesResponse resp = this.client.stringRequest(ListTablesResponse.class, resource, "POST", params, headers, xml);
        for (Table.TableModel model : resp.tables) {
            Table t = new Table(model, model.projectName, model.schemaName, this.odps);
            t.reload(model);
            reloadTables.add(t);
        }
        return reloadTables;
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    private void submitCreateAndWait(String schemaName, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        hints = NameSpaceSchemaUtils.setSchemaFlagInHints(hints, schemaName);
        Instance i = SQLTask.run(this.odps, this.odps.getDefaultProject(), sql, taskName, hints, aliases);
        i.waitForSuccess();
    }

    public TableCreator newTableCreator(String tableName, TableSchema schema) {
        return new TableCreator(this.odps, this.odps.getDefaultProject(), tableName, schema);
    }

    public TableCreator newTableCreator(String projectName, String tableName, TableSchema schema) {
        return new TableCreator(this.odps, projectName, tableName, schema);
    }

    public static class DataHubInfo {
        Long shardNum;
        Long hubLifecycle;

        public DataHubInfo(Long shardNum, Long hubLifecycle) {
            this.shardNum = shardNum;
            this.hubLifecycle = hubLifecycle;
        }

        public String toString() {
            StringBuilder sql = new StringBuilder();
            if (this.shardNum != null) {
                sql.append(" INTO ").append(this.shardNum).append(" SHARDS");
            }
            if (this.hubLifecycle != null) {
                sql.append(" HUBLIFECYCLE ").append(this.hubLifecycle);
            }
            return sql.toString();
        }
    }

    public static class TableCreator {
        private Odps odps;
        private String projectName;
        private String tableName;
        private TableSchema tableSchema;
        private String schemaName;
        private String comment;
        private boolean ifNotExists = false;
        private Long lifeCycle;
        private Map<String, String> hints;
        private Map<String, String> aliases;
        private List<String> primaryKeys;
        private boolean debug = false;
        private TableFormat tableFormat = TableFormat.APPEND;
        private Table.ClusterInfo clusterInfo;
        private DataHubInfo dataHubInfo;
        private Map<String, String> tblProperties;
        private String storageHandler;
        private List<String> usingResources;
        private Map<String, String> serdeProperties;
        private String location;
        private String selectStatement;
        private Map<String, String> preSetTblProperties = new HashMap<String, String>();

        private TableCreator(Odps odps, String projectName, String tableName, TableSchema tableSchema) {
            ExceptionUtils.checkArgumentNotNull("odps", odps);
            ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
            ExceptionUtils.checkStringArgumentNotNull("tableName", tableName);
            this.odps = odps;
            this.projectName = projectName;
            this.tableName = tableName;
            this.tableSchema = tableSchema;
            this.schemaName = odps.getCurrentSchema();
        }

        public TableCreator withSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public TableCreator withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public TableCreator ifNotExists() {
            this.ifNotExists = true;
            return this;
        }

        public TableCreator virtualView() {
            this.tableFormat = TableFormat.VIEW;
            return this;
        }

        public TableCreator transactionTable() {
            this.preSetTblProperties.put("transactional", "true");
            this.tableFormat = TableFormat.TRANSACTION;
            return this;
        }

        public TableCreator deltaTable() {
            this.preSetTblProperties.put("transactional", "true");
            this.tableFormat = TableFormat.DELTA;
            return this;
        }

        public TableCreator externalTable() {
            this.tableFormat = TableFormat.EXTERNAL;
            return this;
        }

        public TableCreator autoPartitionBy(GenerateExpression expression, String aliasName) {
            Column autoPtColumn = Column.newBuilder((String)aliasName, (TypeInfo)TypeInfoFactory.STRING).withGenerateExpression(expression).build();
            this.tableSchema.setPartitionColumns((List)ImmutableList.of((Object)autoPtColumn));
            return this;
        }

        public TableCreator withLifeCycle(Long lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public TableCreator withClusterInfo(Table.ClusterInfo clusterInfo) {
            this.clusterInfo = clusterInfo;
            return this;
        }

        public TableCreator withPrimaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public TableCreator withDeltaTableBucketNum(Integer bucketNum) {
            Preconditions.checkInteger(bucketNum, 1, "bucketNum");
            this.preSetTblProperties.put("write.bucket.num", String.valueOf(bucketNum));
            return this;
        }

        public TableCreator withTblProperties(Map<String, String> tblProperties) {
            this.tblProperties = tblProperties;
            return this;
        }

        public TableCreator withStorageHandler(String storageHandler) {
            this.storageHandler = storageHandler;
            return this;
        }

        public TableCreator withResources(List<String> usingResources) {
            this.usingResources = usingResources;
            return this;
        }

        public TableCreator withLocation(String location) {
            this.location = location;
            return this;
        }

        public TableCreator withSerdeProperties(Map<String, String> serdeProperties) {
            this.serdeProperties = serdeProperties;
            return this;
        }

        public TableCreator withHints(Map<String, String> hints) {
            this.hints = hints;
            return this;
        }

        public TableCreator withAliases(Map<String, String> aliases) {
            this.aliases = aliases;
            return this;
        }

        public TableCreator withDataHubInfo(DataHubInfo dataHubInfo) {
            this.dataHubInfo = dataHubInfo;
            return this;
        }

        public TableCreator withSelectStatement(String selectStatement) {
            this.selectStatement = selectStatement;
            return this;
        }

        public TableCreator debug() {
            this.debug = true;
            return this;
        }

        public String getSQL() {
            return this.generateCreateTableSql();
        }

        public void create() throws OdpsException {
            this.checkParams();
            this.hints = NameSpaceSchemaUtils.setSchemaFlagInHints(this.hints, this.schemaName);
            Instance i = SQLTask.run(this.odps, this.projectName, this.generateCreateTableSql(), "SQLCreateTableTask", this.hints, this.aliases);
            if (this.debug) {
                String logView = this.odps.logview().generateLogView(i, 24L);
                System.out.println(logView);
            }
            i.waitForSuccess();
        }

        private void checkParams() {
            if (this.tableFormat == TableFormat.EXTERNAL) {
                ExceptionUtils.checkArgumentNotNull("storageHandler", this.storageHandler);
            } else if (this.tableFormat == TableFormat.VIEW) {
                ExceptionUtils.checkStringArgumentNotNull("selectStatement", this.selectStatement);
            } else if (this.tableFormat == TableFormat.DELTA) {
                ExceptionUtils.checkCollectionArgumentNotNull("primaryKey", this.primaryKeys);
            }
        }

        private String handleSelectStatementCause() {
            StringBuilder sql = new StringBuilder();
            switch (this.tableFormat) {
                case APPEND: {
                    sql.append("CREATE TABLE ");
                    if (this.ifNotExists) {
                        sql.append("IF NOT EXISTS ");
                    }
                    sql.append(NameSpaceSchemaUtils.getFullName(this.projectName, this.schemaName, this.tableName));
                    if (this.lifeCycle != null) {
                        sql.append(" LIFECYCLE ").append(this.lifeCycle);
                    }
                    sql.append(" AS (").append(this.selectStatement).append(");");
                    return sql.toString();
                }
                case VIEW: {
                    sql.append("CREATE VIEW ");
                    if (this.ifNotExists) {
                        sql.append("IF NOT EXISTS ");
                    }
                    sql.append(NameSpaceSchemaUtils.getFullName(this.projectName, this.schemaName, this.tableName));
                    if (this.tableSchema != null && !this.tableSchema.getColumns().isEmpty()) {
                        List columns = this.tableSchema.getColumns();
                        sql.append(" (");
                        for (int i = 0; i < columns.size(); ++i) {
                            Column column = (Column)columns.get(i);
                            sql.append(CommonUtils.quoteRef((String)column.getName())).append(" ").append(this.getTypeName(column.getTypeInfo()));
                            if (column.getComment() != null) {
                                sql.append(" COMMENT ").append(CommonUtils.quoteStr((String)column.getComment()));
                            }
                            if (i + 1 >= columns.size()) continue;
                            sql.append(',');
                        }
                        sql.append(')');
                    }
                    sql.append(" AS (").append(this.selectStatement).append(");");
                    return sql.toString();
                }
            }
            throw new IllegalArgumentException("Only 'Append Table' and 'Virtual View' support 'create table as' statement.");
        }

        private String generateCreateTableSql() {
            Map<String, String> allTblProperties;
            List partitionColumns;
            if (!StringUtils.isNullOrEmpty((String)this.selectStatement)) {
                return this.handleSelectStatementCause();
            }
            StringBuilder sql = new StringBuilder();
            if (this.tableFormat == TableFormat.EXTERNAL) {
                sql.append("CREATE EXTERNAL TABLE ");
            } else {
                sql.append("CREATE TABLE ");
            }
            if (this.ifNotExists) {
                sql.append("IF NOT EXISTS ");
            }
            sql.append(NameSpaceSchemaUtils.getFullName(this.projectName, this.schemaName, this.tableName));
            List columns = this.tableSchema.getColumns();
            sql.append(" (");
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                sql.append(CommonUtils.quoteRef((String)column.getName())).append(" ").append(this.getTypeName(column.getTypeInfo()));
                if (!column.isNullable()) {
                    sql.append(" NOT NULL");
                }
                if (StringUtils.isNotBlank((String)column.getDefaultValue())) {
                    sql.append(" DEFAULT ").append(CommonUtils.quoteStr((String)column.getDefaultValue()));
                }
                if (column.getComment() != null) {
                    sql.append(" COMMENT ").append(CommonUtils.quoteStr((String)column.getComment()));
                }
                if (i + 1 >= columns.size()) continue;
                sql.append(',');
            }
            if (this.primaryKeys != null && !this.primaryKeys.isEmpty()) {
                sql.append(", PRIMARY KEY(").append(this.primaryKeys.stream().map(CommonUtils::quoteRef).collect(Collectors.joining(","))).append(")");
            }
            sql.append(')');
            if (this.comment != null) {
                sql.append(" COMMENT ").append(CommonUtils.quoteStr((String)this.comment)).append(" ");
            }
            if (!(partitionColumns = this.tableSchema.getPartitionColumns()).isEmpty()) {
                if (((Column)partitionColumns.get(0)).getGenerateExpression() != null) {
                    sql.append(" AUTO PARTITIONED BY (").append(((Column)partitionColumns.get(0)).getGenerateExpression()).append(" AS ").append(CommonUtils.quoteRef((String)((Column)partitionColumns.get(0)).getName())).append(")");
                } else {
                    sql.append(" PARTITIONED BY (");
                    for (int i = 0; i < partitionColumns.size(); ++i) {
                        Column column = (Column)partitionColumns.get(i);
                        sql.append(CommonUtils.quoteRef((String)column.getName())).append(" ").append(this.getTypeName(column.getTypeInfo()));
                        if (column.getComment() != null) {
                            sql.append(" COMMENT ").append(CommonUtils.quoteStr((String)column.getComment()));
                        }
                        if (i + 1 >= partitionColumns.size()) continue;
                        sql.append(',');
                    }
                    sql.append(')');
                }
            }
            if (this.clusterInfo != null) {
                sql.append(this.clusterInfo);
            }
            if (this.storageHandler != null) {
                sql.append(" STORED BY ").append(CommonUtils.quoteStr((String)this.storageHandler));
            }
            if (this.serdeProperties != null && !this.serdeProperties.isEmpty()) {
                sql.append(" WITH SERDEPROPERTIES (");
                int index = 0;
                for (Map.Entry<String, String> entry : this.serdeProperties.entrySet()) {
                    sql.append(CommonUtils.quoteStr((String)entry.getKey())).append("=").append(CommonUtils.quoteStr((String)entry.getValue()));
                    if (++index == this.serdeProperties.size()) continue;
                    sql.append(" , ");
                }
                sql.append(")");
            }
            if (!StringUtils.isNullOrEmpty((String)this.location)) {
                sql.append(" LOCATION ").append(CommonUtils.quoteStr((String)this.location));
            }
            if (this.usingResources != null && !this.usingResources.isEmpty()) {
                sql.append(" USING ").append(CommonUtils.quoteStr((String)String.join((CharSequence)",", this.usingResources)));
            }
            if (!(allTblProperties = this.getTblProperties()).isEmpty()) {
                sql.append(" TBLPROPERTIES(");
                for (Map.Entry<String, String> entry : allTblProperties.entrySet()) {
                    sql.append(CommonUtils.quoteStr((String)entry.getKey())).append("=").append(CommonUtils.quoteStr((String)entry.getValue())).append(",");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
            }
            if (this.lifeCycle != null) {
                sql.append(" LIFECYCLE ").append(this.lifeCycle);
            }
            if (this.dataHubInfo != null) {
                sql.append(this.dataHubInfo);
            }
            sql.append(';');
            if (this.debug) {
                System.out.println(sql);
            }
            return sql.toString();
        }

        private String getTypeName(TypeInfo typeInfo) {
            if (typeInfo instanceof StructTypeInfo) {
                return ((StructTypeInfo)typeInfo).getTypeName(true);
            }
            return typeInfo.getTypeName();
        }

        private Map<String, String> getTblProperties() {
            HashMap<String, String> allTblProperties = new HashMap<String, String>();
            if (this.tblProperties != null) {
                allTblProperties.putAll(this.tblProperties);
            }
            allTblProperties.putAll(this.preSetTblProperties);
            return allTblProperties;
        }

        public static enum TableFormat {
            APPEND,
            TRANSACTION,
            DELTA,
            EXTERNAL,
            VIEW;

        }
    }

    private class TableListIterator
    extends ListIterator<Table> {
        Map<String, String> params = new HashMap<String, String>();
        private TableFilter filter;
        private String projectName;
        private String schemaName;
        private boolean extended;

        TableListIterator(String projectName, String schemaName, TableFilter filter, boolean extended) {
            this.filter = filter;
            this.projectName = projectName;
            this.schemaName = schemaName;
            this.extended = extended;
            this.params = NameSpaceSchemaUtils.initParamsWithSchema(schemaName);
        }

        @Override
        public List<Table> list(String marker, long maxItems) {
            if (marker != null) {
                this.params.put("marker", marker);
            }
            if (maxItems >= 0L) {
                this.params.put("maxitems", String.valueOf(maxItems));
            }
            return this.list();
        }

        @Override
        public String getMarker() {
            return this.params.get("marker");
        }

        @Override
        protected List<Table> list() {
            ArrayList<Table> tables = new ArrayList<Table>();
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                return null;
            }
            if (this.filter != null) {
                if (this.filter.getName() != null) {
                    this.params.put("name", this.filter.getName());
                }
                if (this.filter.getOwner() != null) {
                    this.params.put("owner", this.filter.getOwner());
                }
                if (this.filter.getType() != null) {
                    this.params.put("type", this.filter.getType().toString());
                }
            }
            if (this.extended) {
                this.params.put("extended", null);
            }
            String resource = ResourceBuilder.buildTablesResource(this.projectName);
            try {
                ListTablesResponse resp = Tables.this.client.request(ListTablesResponse.class, resource, "GET", this.params);
                for (Table.TableModel model : resp.tables) {
                    Table t = new Table(model, this.projectName, this.schemaName, Tables.this.odps);
                    tables.add(t);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return tables;
        }
    }

    @Root(name="Tables", strict=false)
    private static class QueryTables {
        @ElementList(entry="Table", inline=true, required=false)
        private List<QueryTable> tables = new ArrayList<QueryTable>();

        private QueryTables() {
        }

        @Root(name="Table", strict=false)
        private static class QueryTable {
            @Element(name="Project", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String projectName;
            @Element(name="Name", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String tableName;
            @Element(name="Schema", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String schemaName;

            QueryTable() {
            }

            QueryTable(String projectName, String schemaName, String tableName) {
                this.projectName = projectName;
                this.schemaName = schemaName;
                this.tableName = tableName;
            }
        }
    }

    @Root(name="Tables", strict=false)
    private static class ListTablesResponse {
        @ElementList(entry="Table", inline=true, required=false)
        private List<Table.TableModel> tables = new ArrayList<Table.TableModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListTablesResponse() {
        }
    }
}

