/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.util.fs;

import com.aliyun.odps.io.OutputStreamSet;
import com.aliyun.odps.io.SinkOutputStream;
import com.aliyun.odps.udf.local.util.fs.LocalOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;

public class LocalOutputStreamSet
implements OutputStreamSet,
Closeable {
    private File directory;
    Set<LocalOutputStream> outputStreams;

    public LocalOutputStreamSet(String path) throws IOException {
        this.directory = new File(path);
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        this.outputStreams = new HashSet<LocalOutputStream>();
    }

    public SinkOutputStream next() throws IOException {
        return this.next("");
    }

    public SinkOutputStream next(String fileNamePostfix) throws IOException {
        String fileName = UUID.randomUUID().toString().substring(0, 8);
        LocalOutputStream stream = new LocalOutputStream(new File(FilenameUtils.concat((String)this.directory.getAbsolutePath(), (String)fileName)));
        this.outputStreams.add(stream);
        return stream;
    }

    @Override
    public void close() throws IOException {
        for (LocalOutputStream stream : this.outputStreams) {
            stream.finalize();
        }
    }
}

