/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.runner;

import com.aliyun.odps.Odps;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.security.ApplicatitionType;
import com.aliyun.odps.local.common.security.SecurityClient;
import com.aliyun.odps.udf.UDF;
import com.aliyun.odps.udf.local.LocalExecutionContext;
import com.aliyun.odps.udf.local.LocalRunException;
import com.aliyun.odps.udf.local.datasource.InputSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;

public abstract class BaseRunner {
    boolean hasClosed = false;
    protected LocalExecutionContext context = new LocalExecutionContext();
    protected List<Object[]> buffer = new ArrayList<Object[]>();
    protected List<InputSource> inputSources = new LinkedList<InputSource>();

    public BaseRunner(Odps odps) {
        WareHouse.getInstance().setOdps(odps);
        this.initSecurity();
    }

    private void initSecurity() {
        LinkedList<String> codeBase = new LinkedList<String>();
        String path = BaseRunner.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = path.substring(path.indexOf(":") + 1);
        codeBase.add(path);
        path = UDF.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = path.substring(path.indexOf(":") + 1);
        codeBase.add(path);
        path = WareHouse.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = path.substring(path.indexOf(":") + 1);
        codeBase.add(path);
        boolean isSecurityEnabled = System.getProperty("odps.local.security.enable", "false").trim().equalsIgnoreCase("true");
        boolean isJNIEnabled = System.getProperty("odps.local.security.jni.enable", "false").trim().equalsIgnoreCase("true");
        String userDefinePolicy = System.getProperty("odps.local.user.define.policy", "").trim();
        SecurityClient.init((ApplicatitionType)ApplicatitionType.UDF, codeBase, null, (boolean)isSecurityEnabled, (boolean)isJNIEnabled, (String)userDefinePolicy);
    }

    public void addInputSource(InputSource inputSource) {
        if (inputSource != null) {
            try {
                inputSource.setup();
            }
            catch (IOException e) {
                this.close();
                throw new RuntimeException(e);
            }
            this.inputSources.add(inputSource);
        }
    }

    public BaseRunner feed(Object[] input) throws LocalRunException {
        try {
            return this.internalFeed(input);
        }
        catch (LocalRunException e) {
            this.close();
            throw e;
        }
    }

    protected abstract BaseRunner internalFeed(Object[] var1) throws LocalRunException;

    public BaseRunner feedAll(Object[][] inputs) throws LocalRunException {
        if (inputs == null) {
            return this;
        }
        for (Object[] input : inputs) {
            this.feed(input);
        }
        return this;
    }

    public BaseRunner feedAll(List<Object[]> inputs) throws LocalRunException {
        if (inputs == null) {
            return this;
        }
        for (Object[] input : inputs) {
            this.feed(input);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> yield() throws LocalRunException {
        for (InputSource inputSource : this.inputSources) {
            try {
                Object[] data;
                while ((data = inputSource.getNextRow()) != null) {
                    this.feed(data);
                }
            }
            catch (IOException e) {
                this.close();
                throw new LocalRunException(e);
            }
        }
        try {
            List<Object[]> list = this.internalYield();
            return list;
        }
        finally {
            this.close();
        }
    }

    protected abstract List<Object[]> internalYield() throws LocalRunException;

    public void runTest(Object[][] expectedOutputs) throws LocalRunException {
        List<Object[]> yields = this.yield();
        if (expectedOutputs == null && yields == null) {
            return;
        }
        if (expectedOutputs == null) {
            Assert.fail((String)"expected: null,but was: not null");
        } else if (yields == null) {
            Assert.fail((String)"expected: not null,but was: null");
        }
        int count = expectedOutputs.length;
        if (count != yields.size()) {
            Assert.fail((String)("expected size:" + count + ",but wase:" + yields.size()));
        }
        for (int i = 0; i < count; ++i) {
            Assert.assertArrayEquals((String)("Row number(start with 0):" + i + " "), (Object[])expectedOutputs[i], (Object[])yields.get(i));
        }
    }

    public void runTest(List<Object[]> expectedOutputs) throws LocalRunException {
        if (expectedOutputs == null) {
            List<Object[]> yields = this.yield();
            if (expectedOutputs == null && yields == null) {
                return;
            }
            if (expectedOutputs == null) {
                Assert.fail((String)"expected: null,but was: not null");
            } else if (yields == null) {
                Assert.fail((String)"expected: not null,but was: null");
            }
        } else {
            Object[][] expected = new Object[expectedOutputs.size()][];
            expectedOutputs.toArray((T[])expected);
            this.runTest(expected);
        }
    }

    protected final synchronized void close() {
        if (this.hasClosed) {
            return;
        }
        for (InputSource inputSource : this.inputSources) {
            try {
                inputSource.close();
            }
            catch (Exception exception) {}
        }
        this.hasClosed = true;
    }
}

