/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.example.image;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.io.InputStreamSet;
import com.aliyun.odps.io.SourceInputStream;
import com.aliyun.odps.udf.DataAttributes;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.Extractor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageExtractor
extends Extractor {
    private InputStreamSet inputs;
    private DataAttributes attributes;
    private ImageReader reader;
    private int targetedImageWidth = 1024;
    private Column[] outputColumns;
    private ArrayRecord record;
    private String inputImageFormat;
    private String transformedImageFormat;

    public void setup(ExecutionContext ctx, InputStreamSet inputs, DataAttributes attributes) {
        this.inputs = inputs;
        this.attributes = attributes;
        this.outputColumns = this.attributes.getRecordColumns();
        this.record = new ArrayRecord(this.outputColumns);
        this.attributes.verifySchema(new OdpsType[]{OdpsType.STRING, OdpsType.BIGINT, OdpsType.BIGINT, OdpsType.BINARY});
        this.inputImageFormat = this.attributes.getValueByKey("inputImageFormat");
        this.transformedImageFormat = this.attributes.getValueByKey("transformedImageFormat");
        if (this.inputImageFormat == null || this.transformedImageFormat == null) {
            throw new RuntimeException("Both input image format and output image format must be specified.");
        }
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(this.inputImageFormat);
        this.reader = readers.next();
    }

    public Record extract() throws IOException {
        String fileName;
        while (true) {
            SourceInputStream input;
            if ((input = this.inputs.next()) == null) {
                return null;
            }
            fileName = input.getFileName();
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            ImageDimension dimension = this.getImageDimension((InputStream)input);
            if (dimension.getWidth() <= (long)this.targetedImageWidth) break;
            System.out.println("Skipping processing image " + input.getFileName() + " since its width is already larger than " + this.targetedImageWidth);
        }
        BufferedImage image = this.reader.read(0);
        ByteArrayOutputStream buffer = this.getTransformedImage(image);
        this.record.setString(0, fileName.substring(0, fileName.lastIndexOf(46)));
        this.record.setBigint(1, Long.valueOf(this.targetedImageWidth));
        this.record.setBigint(2, Long.valueOf(this.targetedImageWidth));
        this.record.setBinary(3, new Binary(buffer.toByteArray()));
        return this.record;
    }

    public void close() {
    }

    private ImageDimension getImageDimension(InputStream input) throws IOException {
        ImageInputStream imageInput = ImageIO.createImageInputStream(input);
        this.reader.setInput(imageInput, true);
        return new ImageDimension(this.reader.getWidth(0), this.reader.getHeight(0));
    }

    private ByteArrayOutputStream getTransformedImage(BufferedImage inputImage) throws IOException {
        BufferedImage scaledImage = new BufferedImage(this.targetedImageWidth, this.targetedImageWidth, 10);
        Graphics2D g = scaledImage.createGraphics();
        g.drawImage(inputImage, 0, 0, this.targetedImageWidth, this.targetedImageWidth, null);
        g.dispose();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)scaledImage, this.transformedImageFormat, buffer);
        return buffer;
    }

    private class ImageDimension {
        private long width;
        private long height;

        ImageDimension(long width, long height) {
            this.width = width;
            this.height = height;
        }

        long getWidth() {
            return this.width;
        }

        long getHeight() {
            return this.height;
        }
    }
}

