/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.resource;

import com.aliyun.odps.FileResource;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Resource;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class GetResourceCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"get", "resource", "download"};
    private static Pattern PATTERN_PREFIX = Pattern.compile("\\s*GET\\s+RESOURCE(.*)", 2);
    private static Pattern PATTERN = Pattern.compile("\\s*GET\\s+RESOURCE\\s+(.*?)\\s+(.*)", 2);
    private Coordinate coordinate;
    private String path;

    public static void printUsage(PrintStream out, ExecutionContext ctx) {
        if (ctx.isProjectMode()) {
            out.println("Usage: get resource [<project name>:]<resource name> <path>");
        } else {
            out.println("Usage: get resource [[<project name>:]<schema name>:]<resource name> <path>");
        }
    }

    public GetResourceCommand(Coordinate coordinate, String path, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.coordinate = coordinate;
        this.path = path;
    }

    public static GetResourceCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        if (!PATTERN_PREFIX.matcher(cmd).matches()) {
            return null;
        }
        Matcher m = PATTERN.matcher(cmd);
        if (!m.matches()) {
            System.err.println("Usage: get resource [<project name>:[<schema name>:]<resource name> <path>;");
            throw new ODPSConsoleException("Bad command.");
        }
        String resourceName = m.group(1);
        Coordinate coordinate = Coordinate.getCoordinateABC((String)resourceName, (String)":");
        String path = FileUtil.expandUserHomeInPath((String)m.group(2));
        return new GetResourceCommand(coordinate, path, cmd, ctx);
    }

    public void run() throws OdpsException, ODPSConsoleException {
        this.coordinate.interpretByCtx(this.getContext());
        String projectName = this.coordinate.getProjectName();
        String schemaName = this.coordinate.getSchemaName();
        String resourceName = this.coordinate.getObjectName();
        Odps odps = this.getCurrentOdps();
        Resource resource = odps.resources().get(projectName, schemaName, resourceName);
        resource.reload();
        if (!(resource instanceof FileResource)) {
            throw new ODPSConsoleException("Resource should be a File Type Resource(file, jar, py, archive)");
        }
        FileResource fileResource = (FileResource)resource;
        File file = new File(this.path);
        if (file.exists() && file.isDirectory()) {
            file = new File(this.path + File.separator + fileResource.getName());
        }
        FileOutputStream os = null;
        InputStream is = null;
        try {
            os = new FileOutputStream(file);
            is = odps.resources().getResourceAsStream(projectName, schemaName, resourceName);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            try {
                throw new ODPSConsoleException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly((OutputStream)os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        System.err.println("OK");
    }
}

