/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.tunnel;

import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.PluginUtil;
import java.util.Properties;

public class Config {
    private String charset = "utf8";
    private char colDelimiter = (char)44;
    private char rowDelimiter = (char)10;
    private String nullIndicator = "";
    private String dateFormat = "yyyyMMddHHmmss";
    private boolean badDiscard = false;
    private long maxSize = 0x6400000L;

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public char getColDelimiter() {
        return this.colDelimiter;
    }

    public void setColDelimiter(char colDelimiter) {
        this.colDelimiter = colDelimiter;
    }

    public char getRowDelimiter() {
        return this.rowDelimiter;
    }

    public void setRowDelimiter(char rowDelimiter) {
        this.rowDelimiter = rowDelimiter;
    }

    public String getNullIndicator() {
        return this.nullIndicator;
    }

    public void setNullIndicator(String nullIndicator) {
        this.nullIndicator = nullIndicator;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean isBadDiscard() {
        return this.badDiscard;
    }

    public void setBadDiscard(boolean badDiscard) {
        this.badDiscard = badDiscard;
    }

    public static Config getConfig() throws ODPSConsoleException {
        Config conf = new Config();
        try {
            String max_size;
            String badDiscard;
            String rowDelimiter;
            String colDelimiter;
            String dateFormat;
            String nullIndicator;
            Properties properties = PluginUtil.getPluginProperty(Config.class);
            String charset = properties.getProperty("charset");
            if (charset != null) {
                conf.setCharset(charset);
            }
            if ((nullIndicator = properties.getProperty("null.indicator")) != null) {
                conf.setNullIndicator(nullIndicator);
            }
            if ((dateFormat = properties.getProperty("date.format")) != null) {
                conf.setDateFormat(dateFormat);
            }
            if ((colDelimiter = properties.getProperty("col.delimiter")) != null) {
                int i = Integer.valueOf(colDelimiter);
                conf.setColDelimiter((char)i);
            }
            if ((rowDelimiter = properties.getProperty("row.delimiter")) != null) {
                int i = Integer.valueOf(rowDelimiter);
                conf.setRowDelimiter((char)i);
            }
            if ((badDiscard = properties.getProperty("bad.discard")) != null) {
                conf.setBadDiscard(Boolean.valueOf(badDiscard));
            }
            if ((max_size = properties.getProperty("max.size")) != null) {
                conf.setMaxSize(Long.valueOf(max_size));
            }
        }
        catch (Exception e) {
            throw new ODPSConsoleException("pls check plugin.ini.", (Throwable)e);
        }
        return conf;
    }
}

