/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.conf;

import com.aliyun.odps.Column;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.RecordComparator;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.SchemaUtils;

public class BridgeJobConf
extends JobConf {
    private static final String COMBINER_CACHE_SPILL_PERCENT = "odps.mapred.combiner.cache.spill.percent";
    private static final String COMBINER_OPTIMIZE_ENABLE = "odps.mapred.combiner.optimize.enable";
    private static final String OUTPUT_KEY_COMPARATOR_CLASS = "odps.stage.mapred.output.key.comparator.class";
    private static final String OUTPUT_KEY_GROUPING_COMPARATOR_CLASS = "odps.mapred.output.key.grouping.comparator.class";
    private static final String PIPELINE = "odps.pipeline.";
    private static final String KEY_COMPARATOR_CLASS = ".output.key.comparator.class";
    private static final String KEY_GROUPING_COMPARATOR_CLASS = ".output.key.grouping.comparator.class";
    public static final String INNER_OUTPUT_ENABLE = "odps.mapred.inner.output.enable";
    public static final String MAPPER_INNER_OUTPUT_ENABLE = "odps.mapred.mapper.inner.output.enable";
    public static final String OUTPUT_OVERWRITE = "odps.mapred.output.overwrite";

    public BridgeJobConf(boolean loadSessionContext) {
        super(loadSessionContext);
    }

    public BridgeJobConf(Configuration conf) {
        super(conf);
    }

    public BridgeJobConf() {
    }

    public Column[] getInputSchema(TableInfo table) {
        return SchemaUtils.fromString((String)this.get("odps.mapred.input.schema." + table.getProjectName().toLowerCase() + "." + table.getTableName().toLowerCase()));
    }

    public void setInputSchema(TableInfo table, Column[] schema) {
        this.set("odps.mapred.input.schema." + table.getProjectName().toLowerCase() + "." + table.getTableName().toLowerCase(), SchemaUtils.toString((Column[])schema));
    }

    public Column[] getOutputSchema() {
        return SchemaUtils.fromString((String)this.get("odps.mapred.output.schema.__default__"));
    }

    public Column[] getOutputSchema(String label) {
        String schema = this.get("odps.mapred.output.schema." + label);
        assert (schema != null);
        return SchemaUtils.fromString((String)schema);
    }

    public void setOutputSchema(Column[] schema, String label) {
        this.set("odps.mapred.output.schema." + label, SchemaUtils.toString((Column[])schema));
    }

    public float getCombinerCacheSpillPercent() {
        return this.getFloat(COMBINER_CACHE_SPILL_PERCENT, 0.5f);
    }

    public boolean getCombinerOptimizeEnable() {
        return this.getBoolean(COMBINER_OPTIMIZE_ENABLE, false);
    }

    public Class<? extends RecordComparator> getOutputKeyComparatorClass() {
        return this.getClass(OUTPUT_KEY_COMPARATOR_CLASS, null, RecordComparator.class);
    }

    public Class<? extends RecordComparator> getOutputKeyGroupingComparatorClass() {
        return this.getClass(OUTPUT_KEY_GROUPING_COMPARATOR_CLASS, null, RecordComparator.class);
    }

    public Class<? extends RecordComparator> getPipelineOutputKeyComparatorClass(int idx) {
        return this.getClass(PIPELINE + idx + KEY_COMPARATOR_CLASS, null, RecordComparator.class);
    }

    public Class<? extends RecordComparator> getPipelineOutputKeyGroupingComparatorClass(int idx) {
        return this.getClass(PIPELINE + idx + KEY_GROUPING_COMPARATOR_CLASS, null, RecordComparator.class);
    }

    public boolean getInnerOutputEnable() {
        return this.getBoolean(INNER_OUTPUT_ENABLE, false);
    }

    public void setMapperInnerOutputEnable(boolean mapperInnerOutputEnable) {
        this.setBoolean(MAPPER_INNER_OUTPUT_ENABLE, mapperInnerOutputEnable);
    }

    public boolean getMapperInnerOutputEnable() {
        return this.getBoolean(MAPPER_INNER_OUTPUT_ENABLE, true);
    }

    public boolean getOutputOverwrite() {
        return this.getBoolean(OUTPUT_OVERWRITE, true);
    }
}

