/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Table;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.data.VolumeInfo;
import com.aliyun.odps.mapred.bridge.ErrorCode;
import com.aliyun.odps.mapred.bridge.MetaExplorer;
import com.aliyun.odps.mapred.bridge.utils.Validator;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.pipeline.Pipeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ValidatorFactory {
    private static boolean between(long i, long l, long h) {
        return i <= h && i >= l;
    }

    private static boolean validateColumns(String[] columns, Column[] schema, StringBuilder errorMsg) {
        int i;
        HashSet<String> schemaColums = new HashSet<String>();
        for (i = 0; i < schema.length; ++i) {
            schemaColums.add(schema[i].getName());
        }
        for (i = 0; i < columns.length; ++i) {
            if (schemaColums.contains(columns[i])) continue;
            errorMsg.append("Can't find column " + columns[i] + " from key schema.");
            return false;
        }
        return true;
    }

    static void throwException(ErrorCode e) throws OdpsException {
        throw new OdpsException(e.code, e.msg);
    }

    static void throwException(ErrorCode e, String info) throws OdpsException {
        throw new OdpsException(e.code, e.msg + ":" + info);
    }

    public static void throwException(ErrorCode e, Throwable cause) throws OdpsException {
        throw new OdpsException(e.code, e.msg, cause);
    }

    public static Validator getValidator(JobConf job, MetaExplorer explorer) {
        CompositeValidator validator = new CompositeValidator();
        if (Pipeline.fromJobConf((JobConf)job) == null) {
            validator.addValidator(new ConfigValidator(job));
        } else {
            validator.addValidator(new PipelineValidtor(job));
        }
        validator.addValidator(new InputOutputValidator(job, explorer));
        validator.addValidator(new ResourceValidator(job, explorer));
        return validator;
    }

    static class PipelineValidtor
    implements Validator {
        private Pipeline pipeline;

        public PipelineValidtor(JobConf job) {
            this.pipeline = Pipeline.fromJobConf((JobConf)job);
        }

        @Override
        public void validate() throws OdpsException {
            if (this.pipeline == null) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Pipeline not specified.");
            }
            if (this.pipeline.getNodeNum() == 0) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Pipeline is empty.");
            }
            if (this.pipeline.getFirstNode().getType().equals("reduce")) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "First operator of pipeline must be mapper");
            }
            for (int i = 0; i < this.pipeline.getNodeNum(); ++i) {
                if (i > 0 && this.pipeline.getNode(i).getType().equals("map")) {
                    ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Operators after first node must be reducer");
                }
                if (i >= this.pipeline.getNodeNum() - 1) continue;
                if (this.pipeline.getNode(i).getOutputKeySchema() == null) {
                    ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Operator ouput key schema not set");
                }
                if (this.pipeline.getNode(i).getOutputValueSchema() != null) continue;
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Operator ouput value schema not set");
            }
            StringBuilder errorMsg = new StringBuilder();
            if (!this.validatePartitionColumns(this.pipeline, errorMsg)) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Key partition columns should be inside of output key columns. " + errorMsg);
            }
        }

        private boolean validatePartitionColumns(Pipeline pipeline, StringBuilder errorMsg) {
            Pipeline.TransformNode node = null;
            for (int i = 0; i < pipeline.getNodeNum() - 1; ++i) {
                node = pipeline.getNode(i);
                if (node.getPartitionerClass() != null || ValidatorFactory.validateColumns(node.getPartitionColumns(), node.getOutputKeySchema(), errorMsg)) continue;
                return false;
            }
            return true;
        }
    }

    static class ResourceValidator
    implements Validator {
        private JobConf job;
        private MetaExplorer explorer;

        public ResourceValidator(JobConf job, MetaExplorer explorer) {
            this.job = job;
            this.explorer = explorer;
        }

        @Override
        public void validate() throws OdpsException {
            String[] res = this.job.getResources();
            if (res == null || res.length <= 0) {
                return;
            }
            if (res.length > 256) {
                ValidatorFactory.throwException(ErrorCode.TOO_MANY_RESOURCE_ITEMS, "Acturally " + String.valueOf(res.length));
            }
        }
    }

    static class ConfigValidator
    implements Validator {
        private JobConf job;

        public ConfigValidator(JobConf job) {
            this.job = job;
        }

        @Override
        public void validate() throws OdpsException {
            StringBuilder errorMsg;
            if (this.job.get("odps.mapred.map.class") == null) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Mapper class not specified.");
            }
            if (InputUtils.getTables((JobConf)this.job) == null && !ValidatorFactory.between(this.job.getNumMapTasks(), 0L, 99999L)) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Map tasks " + this.job.getNumMapTasks() + " out of bound, should be in [0, 99999] range.");
            }
            if (!ValidatorFactory.between(this.job.getNumReduceTasks(), 0L, 99999L)) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Reduce tasks " + this.job.getNumReduceTasks() + " out of bound, should be in [0, 99999] range.");
            }
            if (this.job.getNumReduceTasks() != 0 && this.job.get("odps.mapred.reduce.class") == null) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Reducer class not specified.");
            }
            if (this.job.getNumReduceTasks() != 0 && !this.validateSchema(this.job.getMapOutputKeySchema())) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Malformed map output key schema:" + this.job.get("odps.mapred.mapoutput.key.schema"));
            }
            if (this.job.getNumReduceTasks() != 0 && !this.validateSchema(this.job.getMapOutputValueSchema())) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Malformed map output value schema:" + this.job.get("odps.mapred.mapoutput.value.schema"));
            }
            if (!ValidatorFactory.between(this.job.getMemoryForJVM(), 256L, 12288L)) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Memory for jvm " + this.job.getMemoryForJVM() + " out of bound, should be in [256, 12288] range.");
            }
            if (this.job.getOutputKeySortColumns().length != this.job.getOutputKeySortOrder().length) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Key sort columns length should match key sort order length. Sort columns are " + Arrays.toString(this.job.getOutputKeySortColumns()) + " but sort order is " + Arrays.toString(this.job.getOutputKeySortOrder()));
            }
            if (!this.validatePartitionColumns(this.job, errorMsg = new StringBuilder())) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Key partition columns should be inside of output key columns. " + errorMsg);
            }
            if (!ValidatorFactory.between(this.job.getFunctionTimeout(), 1L, 3600L)) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Function timeout " + this.job.getFunctionTimeout() + " out of bound, should be in [1, 3600] range.");
            }
            if (!ValidatorFactory.between(this.job.getInstancePriority(), 0L, 9L)) {
                ValidatorFactory.throwException(ErrorCode.ILLEGAL_CONFIG, "Instance priority" + this.job.getInstancePriority() + " out of bound, should be in [0, 9] range.");
            }
        }

        private boolean validatePartitionColumns(JobConf job, StringBuilder errorMsg) {
            if (job.getNumReduceTasks() > 0 && job.getPartitionerClass() == null) {
                return ValidatorFactory.validateColumns(job.getPartitionColumns(), job.getMapOutputKeySchema(), errorMsg);
            }
            return true;
        }

        private boolean validateSchema(Column[] schema) {
            return schema != null && schema.length >= 1;
        }
    }

    static class InputOutputValidator
    implements Validator {
        private JobConf job;
        private MetaExplorer explorer;

        public InputOutputValidator(JobConf job, MetaExplorer explorer) {
            this.job = job;
            this.explorer = explorer;
        }

        private void validateTable(TableInfo table, Map<String, Table> distinctTables, boolean isInput) throws OdpsException {
            LinkedHashMap partSpec;
            Table tableDesc = distinctTables.get(table.getProjectName() + "." + table.getTableName());
            if (tableDesc == null) {
                if (!this.explorer.existsTable(table.getProjectName(), table.getTableName())) {
                    ValidatorFactory.throwException(ErrorCode.TABLE_NOT_FOUND, table.toString());
                }
                if ((tableDesc = this.explorer.getTable(table.getProjectName(), table.getTableName())).isVirtualView() && (!isInput || this.job.isPipeline() || InputUtils.getTables((JobConf)this.job).length > 1)) {
                    ValidatorFactory.throwException(ErrorCode.VIEW_TABLE, table.toString());
                }
                distinctTables.put(table.getProjectName() + "." + table.getTableName(), tableDesc);
            }
            if ((partSpec = table.getPartSpec()) != null) {
                List cols = tableDesc.getSchema().getPartitionColumns();
                ArrayList<String> colNames = new ArrayList<String>();
                for (Column c : cols) {
                    colNames.add(c.getName());
                }
                for (String key : partSpec.keySet()) {
                    if (colNames.contains(key.toLowerCase())) continue;
                    ValidatorFactory.throwException(ErrorCode.PARTITION_COLUMN_NOT_FOUND, key);
                }
            }
            if (table.getCols() != null) {
                List schema = tableDesc.getSchema().getColumns();
                HashSet<String> names = new HashSet<String>(Arrays.asList(table.getCols()));
                names.removeAll(Arrays.asList(SchemaUtils.getNames((Column[])schema.toArray(new Column[schema.size()]))));
                if (!names.isEmpty()) {
                    ValidatorFactory.throwException(ErrorCode.COLUMN_NOT_FOUND, StringUtils.join(names, (String)","));
                }
            }
        }

        private void validateVolume(VolumeInfo volume, Set<String> distinctVolumes) throws OdpsException {
            String volumeDesc = volume.getProjectName() + "." + volume.getVolumeName() + "." + volume.getPartSpec();
            if (distinctVolumes.contains(volumeDesc)) {
                ValidatorFactory.throwException(ErrorCode.DUPLICATED_VOLUME_FOUND, volume.toString());
            }
            distinctVolumes.add(volumeDesc);
            if (volume.getProjectName() == null) {
                volume.setProjectName(this.explorer.getDefaultProject());
            }
            if (volume.getVolumeName() == null || volume.getVolumeName().isEmpty()) {
                ValidatorFactory.throwException(ErrorCode.MALFORMED_VOLUME_SPEC, "volume name not specified");
            }
            if (volume.getPartSpec() == null || volume.getPartSpec().isEmpty()) {
                ValidatorFactory.throwException(ErrorCode.MALFORMED_VOLUME_SPEC, "volume partition not specified");
            }
            if (!this.explorer.existsVolume(volume.getProjectName(), volume.getVolumeName())) {
                ValidatorFactory.throwException(ErrorCode.VOLUME_NOT_FOUND, volume.toString());
            }
            if (!ValidatorFactory.between(volume.getLabel().length(), 3L, 32L) || !volume.getLabel().matches("[A-Z,a-z,0-9,_,#,\\.,\\-]*")) {
                ValidatorFactory.throwException(ErrorCode.MALFORMED_VOLUME_SPEC, "illegal label " + volume.getLabel() + ", expecting [A-Z,a-z,0-9,_,#,\\.,\\-]* with length of [3,32]");
            }
        }

        private void validateTables(TableInfo[] tables) throws OdpsException {
            HashMap<String, Table> distinctOutputTables = new HashMap<String, Table>();
            HashSet<String> labelNames = new HashSet<String>();
            for (TableInfo table : tables) {
                this.validateTable(table, distinctOutputTables, false);
                if (labelNames.contains(table.getLabel())) {
                    ValidatorFactory.throwException(ErrorCode.OUTPUT_LABEL_NOT_UNIQUE, table.getLabel());
                }
                labelNames.add(table.getLabel());
            }
        }

        private void validateVolumes(VolumeInfo[] volumes) throws OdpsException {
            HashSet<String> distinctVolumes = new HashSet<String>();
            HashSet<String> labelNames = new HashSet<String>();
            for (VolumeInfo volume : volumes) {
                this.validateVolume(volume, distinctVolumes);
                if (labelNames.contains(volume.getLabel())) {
                    ValidatorFactory.throwException(ErrorCode.VOLUME_LABEL_NOT_UNIQUE, volume.getLabel());
                }
                labelNames.add(volume.getLabel());
            }
        }

        @Override
        public void validate() throws OdpsException {
            VolumeInfo[] volumes;
            TableInfo[] tables = InputUtils.getTables((JobConf)this.job);
            if (tables != null && tables.length > 0) {
                if (tables.length > 1024) {
                    ValidatorFactory.throwException(ErrorCode.TOO_MANY_INPUT_TABLE, "Expecting no more than 1024 partitions. ");
                }
                HashMap<String, Table> distinctInputTables = new HashMap<String, Table>();
                for (TableInfo table : tables) {
                    this.validateTable(table, distinctInputTables, true);
                    if (distinctInputTables.size() <= 64) continue;
                    ValidatorFactory.throwException(ErrorCode.TOO_MANY_INPUT_TABLE, "Expecting no more than 64 distinct tables. ");
                }
            }
            if ((tables = OutputUtils.getTables((JobConf)this.job)) != null && tables.length > 0) {
                this.validateTables(tables);
            }
            if ((volumes = InputUtils.getVolumes((JobConf)this.job)) != null && volumes.length > 0) {
                if (volumes.length > 1024) {
                    ValidatorFactory.throwException(ErrorCode.TOO_MANY_INPUT_VOLUME, "Expecting no more than 1024 partitions. ");
                }
                this.validateVolumes(volumes);
            }
            if ((volumes = OutputUtils.getVolumes((JobConf)this.job)) != null && volumes.length > 0) {
                if (volumes.length > 1024) {
                    ValidatorFactory.throwException(ErrorCode.TOO_MANY_OUTPUT_VOLUME, "Expecting no more than 1024 partitions. ");
                }
                this.validateVolumes(volumes);
            }
        }
    }

    static class CompositeValidator
    implements Validator {
        List<Validator> validators = new ArrayList<Validator>();

        CompositeValidator() {
        }

        public void addValidator(Validator v) {
            this.validators.add(v);
        }

        @Override
        public void validate() throws OdpsException {
            for (Validator v : this.validators) {
                v.validate();
            }
        }
    }
}

