/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.utils;

import com.aliyun.odps.Record;
import com.aliyun.odps.cache.DistributedCache;
import com.aliyun.odps.mapred.bridge.utils.VersionUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Iterator;

public final class ResourceUtils {
    public static BufferedInputStream readResourceFileAsStream(String resourceName) throws IOException {
        return DistributedCache.readCacheFileAsStream(resourceName);
    }

    public static Iterable<BufferedInputStream> readResourceArchiveFileAsStream(String resourceName) throws IOException {
        return DistributedCache.readCacheArchiveAsStream(resourceName);
    }

    public static Iterable<BufferedInputStream> readResourceArchiveFileAsStream(String resourceName, String relativePath) throws IOException {
        return DistributedCache.readCacheArchiveAsStream(resourceName, relativePath);
    }

    public static Iterator<com.aliyun.odps.data.Record> readResourceTable(String resourceName) throws IOException {
        final Iterator<Record> itr = DistributedCache.readCacheTable(resourceName).iterator();
        return new Iterator<com.aliyun.odps.data.Record>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public com.aliyun.odps.data.Record next() {
                Record r = (Record)itr.next();
                return VersionUtils.adaptRecord(r);
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }
}

