/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.streaming.io;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.bridge.streaming.PipeMapRed;
import com.aliyun.odps.mapred.bridge.streaming.io.InputWriter;
import com.aliyun.odps.mapred.bridge.streaming.io.TextInputWriter;
import java.io.DataOutput;
import java.io.IOException;

public class RecordInputWriter
extends InputWriter<Object, Record> {
    private DataOutput clientOut;
    private byte[] inputSeparator;

    @Override
    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        this.clientOut = pipeMapRed.getClientOutput();
        this.inputSeparator = pipeMapRed.getInputSeparator();
    }

    @Override
    public void writeKey(Object key) throws IOException {
    }

    @Override
    public void writeValue(Record value) throws IOException {
        for (int col = 0; col < value.getColumnCount(); ++col) {
            Object colValue;
            if (col > 0) {
                this.clientOut.write(this.inputSeparator);
            }
            if ((colValue = value.get(col)) == null) {
                colValue = "";
            }
            TextInputWriter.writeUTF8(colValue, this.clientOut);
        }
        this.clientOut.write(10);
    }
}

