/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.streaming;

import com.aliyun.odps.io.Text;
import com.aliyun.odps.mapred.bridge.streaming.io.LineReader;
import com.aliyun.odps.mapred.utils.UTF8ByteArrayUtils;
import java.io.IOException;

public class StreamKeyValUtil {
    public static int findTab(byte[] utf, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            if (utf[i] != 9) continue;
            return i;
        }
        return -1;
    }

    public static int findTab(byte[] utf) {
        return UTF8ByteArrayUtils.findNthByte((byte[])utf, (int)0, (int)utf.length, (byte)9, (int)1);
    }

    public static void splitKeyVal(byte[] utf, int start, int length, Text key, Text val, int splitPos, int separatorLength) throws IOException {
        if (splitPos < start || splitPos >= start + length) {
            throw new IllegalArgumentException("splitPos must be in the range [" + start + ", " + (start + length) + "]: " + splitPos);
        }
        int keyLen = splitPos - start;
        int valLen = start + length - splitPos - separatorLength;
        key.set(utf, start, keyLen);
        val.set(utf, splitPos + separatorLength, valLen);
    }

    public static void splitKeyVal(byte[] utf, int start, int length, Text key, Text val, int splitPos) throws IOException {
        StreamKeyValUtil.splitKeyVal(utf, start, length, key, val, splitPos, 1);
    }

    public static void splitKeyVal(byte[] utf, Text key, Text val, int splitPos, int separatorLength) throws IOException {
        StreamKeyValUtil.splitKeyVal(utf, 0, utf.length, key, val, splitPos, separatorLength);
    }

    public static void splitKeyVal(byte[] utf, Text key, Text val, int splitPos) throws IOException {
        StreamKeyValUtil.splitKeyVal(utf, 0, utf.length, key, val, splitPos, 1);
    }

    public static int readLine(LineReader lineReader, Text out) throws IOException {
        out.clear();
        return lineReader.readLine(out);
    }
}

