/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.streaming;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.Resource;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.bridge.MetaExplorerImpl;
import com.aliyun.odps.mapred.bridge.streaming.Environment;
import com.aliyun.odps.mapred.bridge.streaming.PipeCombiner;
import com.aliyun.odps.mapred.bridge.streaming.PipeMapper;
import com.aliyun.odps.mapred.bridge.streaming.PipeReducer;
import com.aliyun.odps.mapred.bridge.streaming.StreamUtil;
import com.aliyun.odps.mapred.bridge.streaming.io.InputWriter;
import com.aliyun.odps.mapred.bridge.streaming.io.OutputReader;
import com.aliyun.odps.mapred.bridge.streaming.io.RecordInputWriter;
import com.aliyun.odps.mapred.bridge.streaming.io.RecordOutputReader;
import com.aliyun.odps.mapred.bridge.streaming.io.TextInputWriter;
import com.aliyun.odps.mapred.bridge.streaming.io.TextOutputReader;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.UTF8ByteArrayUtils;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamJob {
    protected static final Log LOG = LogFactory.getLog((String)StreamJob.class.getName());
    static final String REDUCE_NONE = "NONE";
    private CommandLineParser parser = new BasicParser();
    private Options allOptions;
    protected String[] argv_;
    protected boolean background_;
    protected boolean verbose_;
    protected boolean detailedUsage_;
    protected boolean printUsage = false;
    protected int debug_;
    protected Environment env_;
    protected JobConf config_;
    protected JobConf jobConf_;
    protected ArrayList<TableInfo> inputSpecs_ = new ArrayList();
    protected ArrayList<String> packageFiles_ = new ArrayList();
    protected ArrayList<String> shippedCanonFiles_ = new ArrayList();
    protected String output_;
    protected String mapCmd_;
    protected String comCmd_;
    protected String redCmd_;
    protected String partitionerSpec_;
    protected String numReduceTasksSpec_;
    protected String additionalConfSpec_;
    protected String mapDebugSpec_;
    protected String reduceDebugSpec_;
    protected String ioSpec_;
    protected boolean lazyOutput_;
    protected String addTaskEnvironment_;
    protected RunningJob running_;
    protected static final String LINK_URI = "You need to specify the uris as scheme://path#linkname,Please specify a different link name for all of your caching URIs";

    public StreamJob() {
        this.setupOptions();
        this.config_ = new JobConf();
    }

    public Configuration getConf() {
        return this.config_;
    }

    public int run(String[] args) throws Exception {
        for (String aa : args) {
            LOG.debug((Object)("arg: '" + aa + "'"));
        }
        try {
            this.argv_ = Arrays.copyOf(args, args.length);
            this.init();
            this.preProcessArgs();
            this.parseArgv();
            if (this.printUsage) {
                this.printUsage(this.detailedUsage_);
                return 0;
            }
            this.postProcessArgs();
            this.setJobConf();
        }
        catch (IllegalArgumentException ex) {
            LOG.debug((Object)"Error in streaming job", (Throwable)ex);
            ex.printStackTrace();
            return 1;
        }
        return this.submitAndMonitorJob();
    }

    public static JobConf createJob(String[] argv) throws IOException {
        StreamJob job = new StreamJob();
        job.argv_ = argv;
        job.init();
        job.preProcessArgs();
        job.parseArgv();
        job.postProcessArgs();
        job.setJobConf();
        return job.jobConf_;
    }

    protected void init() {
        try {
            this.env_ = new Environment();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    void preProcessArgs() {
        this.verbose_ = false;
        this.addTaskEnvironment_ = "HADOOP_ROOT_LOGGER=";
    }

    void postProcessArgs() throws IOException {
        this.msg("addTaskEnvironment=" + this.addTaskEnvironment_);
        for (String packageFile : this.packageFiles_) {
            File f = new File(packageFile);
            if (!f.isFile()) continue;
            this.shippedCanonFiles_.add(f.getCanonicalPath());
        }
        this.msg("shippedCanonFiles_=" + this.shippedCanonFiles_);
        this.mapCmd_ = this.unqualifyIfLocalPath(this.mapCmd_);
        this.comCmd_ = this.unqualifyIfLocalPath(this.comCmd_);
        this.redCmd_ = this.unqualifyIfLocalPath(this.redCmd_);
    }

    String unqualifyIfLocalPath(String cmd) throws IOException {
        if (cmd != null) {
            String progCanon;
            String prog = cmd;
            String args = "";
            int s = cmd.indexOf(" ");
            if (s != -1) {
                prog = cmd.substring(0, s);
                args = cmd.substring(s + 1);
            }
            try {
                progCanon = new File(prog).getCanonicalPath();
            }
            catch (IOException io) {
                progCanon = prog;
            }
            boolean shipped = this.shippedCanonFiles_.contains(progCanon);
            this.msg("shipped: " + shipped + " " + progCanon);
            if (shipped) {
                prog = new File(prog).getName();
                cmd = args.length() > 0 ? prog + " " + args : prog;
            }
        }
        this.msg("cmd=" + cmd);
        return cmd;
    }

    void parseArgv() {
        String[] caf;
        CommandLine cmdLine = null;
        try {
            cmdLine = this.parser.parse(this.allOptions, this.argv_);
        }
        catch (Exception oe) {
            LOG.error((Object)oe.getMessage());
            this.exitUsage(this.argv_.length > 0 && "-info".equals(this.argv_[0]));
        }
        if (cmdLine == null) {
            this.exitUsage(this.argv_.length > 0 && "-info".equals(this.argv_[0]));
            return;
        }
        List args = cmdLine.getArgList();
        if (args != null && args.size() > 0) {
            this.fail("Found " + args.size() + " unexpected arguments on the command line " + args);
        }
        this.detailedUsage_ = cmdLine.hasOption("info");
        if (cmdLine.hasOption("help") || this.detailedUsage_) {
            this.printUsage = true;
            return;
        }
        this.verbose_ = cmdLine.hasOption("verbose");
        this.background_ = cmdLine.hasOption("background");
        this.debug_ = cmdLine.hasOption("debug") ? this.debug_ + 1 : this.debug_;
        this.output_ = cmdLine.getOptionValue("output");
        this.comCmd_ = cmdLine.getOptionValue("combiner");
        this.redCmd_ = cmdLine.getOptionValue("reducer");
        this.lazyOutput_ = cmdLine.hasOption("lazyOutput");
        String[] values = cmdLine.getOptionValues("file");
        SessionState ss = SessionState.get();
        MetaExplorerImpl metaExplorer = new MetaExplorerImpl(ss.getOdps());
        HashMap<String, String> aliasToTempResource = new HashMap<String, String>();
        String padding = "_" + UUID.randomUUID().toString();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                String file = values[i];
                this.packageFiles_.add(file);
                try {
                    aliasToTempResource.put(FilenameUtils.getName((String)file), metaExplorer.addFileResourceWithRetry(file, Resource.Type.FILE, padding, true));
                    continue;
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e);
                }
            }
            this.config_.set("stream.temp.resource.alias", new GsonBuilder().disableHtmlEscaping().create().toJson(aliasToTempResource));
            Object[] res = this.config_.getResources();
            Set resources = aliasToTempResource.keySet();
            if (res != null) {
                this.config_.setResources(StringUtils.join((Object[])res, (String)",") + "," + StringUtils.join(resources, (String)","));
            } else {
                this.config_.setResources(StringUtils.join(resources, (String)","));
            }
        }
        this.additionalConfSpec_ = cmdLine.getOptionValue("additionalconfspec");
        this.numReduceTasksSpec_ = cmdLine.getOptionValue("numReduceTasks");
        this.partitionerSpec_ = cmdLine.getOptionValue("partitioner");
        this.mapDebugSpec_ = cmdLine.getOptionValue("mapdebug");
        this.reduceDebugSpec_ = cmdLine.getOptionValue("reducedebug");
        this.ioSpec_ = cmdLine.getOptionValue("io");
        String[] car = cmdLine.getOptionValues("cacheArchive");
        if (null != car) {
            this.fail("no -cacheArchive option any more, please use -resources instead.");
        }
        if (null != (caf = cmdLine.getOptionValues("cacheFile"))) {
            this.fail("no -cacheFile option any more, please use -resources instead.");
        }
        this.mapCmd_ = cmdLine.getOptionValue("mapper");
        String[] cmd = cmdLine.getOptionValues("cmdenv");
        if (null != cmd && cmd.length > 0) {
            for (String s : cmd) {
                if (this.addTaskEnvironment_.length() > 0) {
                    this.addTaskEnvironment_ = this.addTaskEnvironment_ + " ";
                }
                this.addTaskEnvironment_ = this.addTaskEnvironment_ + s;
            }
        }
        HashMap inputConfigs = new HashMap();
        String[] columns = null;
        for (Option opt : cmdLine.getOptions()) {
            if ("jobconf".equals(opt.getOpt())) {
                String[] jobconf = opt.getValues();
                if (null == jobconf || jobconf.length <= 0) continue;
                String[] stringArray = jobconf;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s = stringArray[i];
                    String[] parts = s.split("=", 2);
                    this.config_.set(parts[0], parts[1]);
                }
                continue;
            }
            if ("columns".equals(opt.getOpt())) {
                String columnsValue = opt.getValue();
                if (columnsValue.equals("ALL")) {
                    columns = null;
                    continue;
                }
                columns = columnsValue.split(",");
                continue;
            }
            if (!"input".equals(opt.getOpt()) || (values = opt.getValues()) == null || values.length <= 0) continue;
            for (String input : values) {
                TableInfo ti = StreamJob.parseTableInfo(input);
                if (columns != null) {
                    ti.setCols(columns);
                }
                this.inputSpecs_.add(ti);
                String inputKey = (ti.getProjectName() + "." + ti.getTableName()).toLowerCase();
                if (inputConfigs.get(inputKey) != null) continue;
                HashMap<String, String> inputConfig = new HashMap<String, String>();
                inputConfig.put("stream.map.input.field.separator", this.config_.get("stream.map.input.field.separator", "\t"));
                inputConfigs.put(inputKey, inputConfig);
            }
        }
        try {
            this.config_.set("stream.map.input.configs", new GsonBuilder().disableHtmlEscaping().create().toJson(inputConfigs));
        }
        catch (Exception e) {
            throw new RuntimeException("fail to set input configs");
        }
    }

    protected void msg(String msg) {
        if (this.verbose_) {
            System.out.println("STREAM: " + msg);
        }
    }

    private Option createOption(String name, String desc, String argName, int max, boolean required) {
        OptionBuilder.withArgName((String)argName);
        OptionBuilder.hasArgs((int)max);
        OptionBuilder.withDescription((String)desc);
        OptionBuilder.isRequired((boolean)required);
        return OptionBuilder.create((String)name);
    }

    private Option createBoolOption(String name, String desc) {
        OptionBuilder.withDescription((String)desc);
        return OptionBuilder.create((String)name);
    }

    private void setupOptions() {
        Option input = this.createOption("input", "Input tables/partitions for the Map step", "path", Integer.MAX_VALUE, false);
        Option columns = this.createOption("columns", "Input table column names for the Map step", "spec", 1, false);
        Option output = this.createOption("output", "Result table/partition for the Reduce step", "path", 1, false);
        Option mapper = this.createOption("mapper", "The streaming command to run", "cmd", 1, false);
        Option combiner = this.createOption("combiner", "The streaming command to run", "cmd", 1, false);
        Option reducer = this.createOption("reducer", "The streaming command to run", "cmd", 1, false);
        Option file = this.createOption("file", "File to be shipped in the Job jar file", "file", Integer.MAX_VALUE, false);
        Option additionalconfspec = this.createOption("additionalconfspec", "Optional.", "spec", 1, false);
        Option partitioner = this.createOption("partitioner", "Optional.", "spec", 1, false);
        Option numReduceTasks = this.createOption("numReduceTasks", "Optional.", "spec", 1, false);
        Option mapDebug = this.createOption("mapdebug", "Optional.", "spec", 1, false);
        Option reduceDebug = this.createOption("reducedebug", "Optional", "spec", 1, false);
        Option jobconf = this.createOption("jobconf", "(n=v) Optional. Add or override a JobConf property.", "spec", 1, false);
        Option cmdenv = this.createOption("cmdenv", "(n=v) Pass env.var to streaming commands.", "spec", 1, false);
        Option cacheFile = this.createOption("cacheFile", "File name URI", "fileNameURI", Integer.MAX_VALUE, false);
        Option cacheArchive = this.createOption("cacheArchive", "File name URI", "fileNameURI", Integer.MAX_VALUE, false);
        Option io = this.createOption("io", "Optional.", "spec", 1, false);
        Option background = this.createBoolOption("background", "Submit the job and don't wait till it completes.");
        Option verbose = this.createBoolOption("verbose", "print verbose output");
        Option info = this.createBoolOption("info", "print verbose output");
        Option help = this.createBoolOption("help", "print this help message");
        Option debug = this.createBoolOption("debug", "print debug output");
        Option lazyOutput = this.createBoolOption("lazyOutput", "create outputs lazily");
        this.allOptions = new Options().addOption(input).addOption(columns).addOption(output).addOption(mapper).addOption(combiner).addOption(reducer).addOption(file).addOption(additionalconfspec).addOption(partitioner).addOption(numReduceTasks).addOption(mapDebug).addOption(reduceDebug).addOption(jobconf).addOption(cmdenv).addOption(cacheFile).addOption(cacheArchive).addOption(io).addOption(background).addOption(verbose).addOption(info).addOption(debug).addOption(help).addOption(lazyOutput);
    }

    public void exitUsage(boolean detailed) {
        this.printUsage(detailed);
        this.fail("");
    }

    private void printUsage(boolean detailed) {
        System.out.println("Usage: jar [-classpath ...] [-resources ...] com.aliyun.odps.mapred.bridge.streaming.StreamJob [options]");
        System.out.println("Options:");
        System.out.println("  -input          <[/prj/]tbl/[pt=x[/ds=y]]> input table/partition for the Map step.");
        System.out.println("  -output         <[/prj/]tbl/[pt=x[/ds=y]]> output table/partition for the Reduce step.");
        System.out.println("  -mapper         <cmd|JavaClassName> Optional. Command to be run as mapper.");
        System.out.println("  -combiner       <cmd|JavaClassName> Optional. Command to be run as combiner.");
        System.out.println("  -reducer        <cmd|JavaClassName> Optional. Command to be run as reducer.");
        System.out.println("  -file           <file> Optional. Local file/dir to be shipped with the streaming job.");
        System.out.println("  -partitioner    <JavaClassName>  Optional. The partitioner class.");
        System.out.println("  -numReduceTasks <num> Optional. Number of reduce tasks.");
        System.out.println("  -cmdenv         <n>=<v> Optional. Pass env.var to streaming commands.");
        System.out.println("  -lazyOutput     Optional. Lazily create Output.");
        System.out.println("  -background     Optional. Submit the job and don't wait till it completes.");
        System.out.println("  -verbose        Optional. Print verbose output.");
        System.out.println("  -info           Optional. Print detailed usage.");
        System.out.println("  -help           Optional. Print help message.");
        System.out.println();
        if (!detailed) {
            System.out.println();
            System.out.println("For more details about these options use -info option.");
            return;
        }
        System.out.println();
        System.out.println("Usage tips:");
        System.out.println("To set the number of reduce tasks (num. of output files) as, say 10:");
        System.out.println("  Use -numReduceTasks 10");
        System.out.println("To skip the sort/combine/shuffle/sort/reduce step:");
        System.out.println("  Use -numReduceTasks 0");
        System.out.println("  Map output then becomes a 'side-effect output' rather than a reduce input.");
        System.out.println("  This speeds up processing. This also feels more like \"in-place\" processing");
        System.out.println("  because the input filename and the map input order are preserved.");
        System.out.println("  This is equivalent to -reducer NONE");
        System.out.println();
        System.out.println("To treat tasks with non-zero exit status as SUCCEDED:");
        System.out.println("  -D stream.non.zero.exit.is.failure=false");
        System.out.println("To set an environement variable in a streaming command:");
        System.out.println("   -cmdenv EXAMPLE_DIR=/home/example/dictionaries/");
    }

    public void fail(String message) {
        System.err.println(message);
        System.err.println("Try -help for more information");
        throw new IllegalArgumentException(message);
    }

    private static TableInfo parseTableInfo(String tableInfoStr) {
        String[] parts;
        String prj = SessionState.get().getOdps().getDefaultProject();
        if (prj == null) {
            throw new RuntimeException("default project should have been set");
        }
        String tbl = null;
        String part = null;
        if (tableInfoStr.startsWith("/")) {
            parts = tableInfoStr.substring(1).split("/", 3);
            if (parts.length < 2) {
                throw new IllegalArgumentException("invalid table info: " + tableInfoStr);
            }
            prj = parts[0];
            tbl = parts[1];
            if (parts.length == 3) {
                part = parts[2];
            }
        } else {
            parts = tableInfoStr.split("/", 2);
            if (parts.length == 0) {
                throw new IllegalArgumentException("invalid table info: " + tableInfoStr);
            }
            tbl = parts[0];
            if (parts.length == 2) {
                part = parts[1];
            }
        }
        TableInfo.TableInfoBuilder builder = TableInfo.builder();
        builder.projectName(prj);
        builder.tableName(tbl);
        if (part != null) {
            builder.partSpec(part);
        }
        return builder.build();
    }

    protected void setJobConf() throws IOException {
        this.jobConf_ = new JobConf((Configuration)this.config_);
        for (int i = 0; i < this.inputSpecs_.size(); ++i) {
            InputUtils.addTable((TableInfo)this.inputSpecs_.get(i), (JobConf)this.jobConf_);
        }
        String defaultPackage = this.getClass().getPackage().getName();
        if (this.ioSpec_ != null) {
            this.jobConf_.set("stream.map.input", this.ioSpec_);
            this.jobConf_.set("stream.map.output", this.ioSpec_);
            this.jobConf_.set("stream.reduce.input", this.ioSpec_);
            this.jobConf_.set("stream.reduce.output", this.ioSpec_);
        }
        this.jobConf_.setClass("stream.map.input.writer.class", RecordInputWriter.class, InputWriter.class);
        this.jobConf_.setClass("stream.reduce.input.writer.class", TextInputWriter.class, InputWriter.class);
        this.jobConf_.set("stream.addenvironment", this.addTaskEnvironment_);
        boolean isMapperACommand = false;
        Class c = null;
        if (this.mapCmd_ != null) {
            c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.mapCmd_, defaultPackage);
            if (c != null) {
                this.jobConf_.setMapperClass(c);
            } else {
                isMapperACommand = true;
                this.jobConf_.setMapperClass(PipeMapper.class);
                this.jobConf_.set("stream.map.streamprocessor", URLEncoder.encode(this.mapCmd_, "UTF-8"));
            }
        }
        if (this.comCmd_ != null) {
            c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.comCmd_, defaultPackage);
            if (c != null) {
                this.jobConf_.setCombinerClass(c);
            } else {
                this.jobConf_.setCombinerClass(PipeCombiner.class);
                this.jobConf_.set("stream.combine.streamprocessor", URLEncoder.encode(this.comCmd_, "UTF-8"));
            }
        }
        if (this.numReduceTasksSpec_ != null) {
            int numReduceTasks = Integer.parseInt(this.numReduceTasksSpec_);
            this.jobConf_.setNumReduceTasks(numReduceTasks);
        }
        boolean isReducerACommand = false;
        if (this.redCmd_ != null) {
            if (this.redCmd_.equals(REDUCE_NONE)) {
                this.jobConf_.setNumReduceTasks(0);
            }
            if (this.jobConf_.getNumReduceTasks() != 0) {
                if (this.redCmd_.compareToIgnoreCase("aggregate") == 0) {
                    throw new UnsupportedOperationException("'aggregate' reducer not supported yet");
                }
                c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.redCmd_, defaultPackage);
                if (c != null) {
                    this.jobConf_.setReducerClass(c);
                } else {
                    isReducerACommand = true;
                    this.jobConf_.setReducerClass(PipeReducer.class);
                    this.jobConf_.set("stream.reduce.streamprocessor", URLEncoder.encode(this.redCmd_, "UTF-8"));
                }
            }
        }
        String mapOutputFieldSeparator = UTF8ByteArrayUtils.unescapeSeparator((String)this.jobConf_.get("stream.map.output.field.separator", "\t"));
        String reduceInputFieldSeparator = UTF8ByteArrayUtils.unescapeSeparator((String)this.jobConf_.get("stream.reduce.input.field.separator", "\t"));
        int numOfMapOutputKeyFields = this.jobConf_.getInt("stream.num.map.output.key.fields", 1);
        if (numOfMapOutputKeyFields > 1 && !mapOutputFieldSeparator.equals(reduceInputFieldSeparator)) {
            throw new IllegalArgumentException("for multiple-fields key, stream.reduce.input.field.separator should be the same as stream.map.output.field.separator to avoid confusion");
        }
        Column[] mapOutputKeySchema = new Column[numOfMapOutputKeyFields];
        Map<Integer, KeyDescription> keyOptions = this.parseKeyOptions(this.jobConf_.get("stream.map.output.key.options", ""));
        for (int i = 0; i < mapOutputKeySchema.length; ++i) {
            KeyDescription keyDesc = keyOptions.get(i + 1);
            OdpsType t = keyDesc == null || !keyDesc.numeric ? OdpsType.STRING : OdpsType.BIGINT;
            mapOutputKeySchema[i] = new Column("map_out_key" + i, t);
        }
        this.jobConf_.setMapOutputKeySchema(mapOutputKeySchema);
        if (!keyOptions.isEmpty()) {
            JobConf.SortOrder[] sortOrder = new JobConf.SortOrder[mapOutputKeySchema.length];
            for (int i = 0; i < mapOutputKeySchema.length; ++i) {
                KeyDescription keyDesc = keyOptions.get(i + 1);
                sortOrder[i] = keyDesc == null || !keyDesc.reverse ? JobConf.SortOrder.ASC : JobConf.SortOrder.DESC;
            }
            this.jobConf_.setOutputKeySortOrder(sortOrder);
        }
        this.jobConf_.setMapOutputValueSchema(new Column[]{new Column("map_out_value", OdpsType.STRING)});
        if (this.partitionerSpec_ != null) {
            if (this.partitionerSpec_.equals("KeyFieldBasedPartitioner")) {
                this.partitionerSpec_ = "com.aliyun.odps.mapred.lib.KeyFieldBasedPartitioner";
            }
            if (this.partitionerSpec_.equals("com.aliyun.odps.mapred.lib.KeyFieldBasedPartitioner")) {
                String mapOutputKeyFieldSeparator = UTF8ByteArrayUtils.unescapeSeparator((String)this.jobConf_.get("map.output.key.field.separator", "\t"));
                if (mapOutputFieldSeparator.equals(mapOutputKeyFieldSeparator)) {
                    int numOfKeyFieldsForPartition = this.jobConf_.getInt("num.key.fields.for.partition", 1);
                    if (numOfKeyFieldsForPartition > numOfMapOutputKeyFields) {
                        throw new IllegalArgumentException("num.key.fields.for.partition should not bigger than stream.num.map.output.key.fields");
                    }
                    if (numOfKeyFieldsForPartition < numOfMapOutputKeyFields) {
                        String[] partitionColumns = new String[numOfKeyFieldsForPartition];
                        for (int i = 0; i < numOfKeyFieldsForPartition; ++i) {
                            partitionColumns[i] = mapOutputKeySchema[i].getName();
                        }
                        this.jobConf_.setPartitionColumns(partitionColumns);
                    }
                } else {
                    c = StreamUtil.goodClassOrNull((Configuration)this.jobConf_, this.partitionerSpec_, defaultPackage);
                    if (c != null) {
                        this.jobConf_.setPartitionerClass(c);
                    }
                }
            } else {
                throw new IllegalArgumentException("User defined partitioner not supported for streaming job");
            }
        }
        Class<TextOutputReader> mapOutputReaderClass = TextOutputReader.class;
        Class reduceOutputReaderClass = RecordOutputReader.class;
        if (this.jobConf_.getNumReduceTasks() > 0) {
            boolean hasKey = this.jobConf_.getInt("stream.num.reduce.output.key.fields", 0) > 0;
            reduceOutputReaderClass = hasKey ? TextOutputReader.class : RecordOutputReader.class;
        } else {
            boolean hasKey = this.jobConf_.getInt("stream.num.map.output.key.fields", 0) > 0;
            mapOutputReaderClass = hasKey ? TextOutputReader.class : RecordOutputReader.class;
        }
        this.jobConf_.setClass("stream.map.output.reader.class", mapOutputReaderClass, OutputReader.class);
        this.jobConf_.setClass("stream.reduce.output.reader.class", reduceOutputReaderClass, OutputReader.class);
        if (this.output_ != null) {
            OutputUtils.addTable((TableInfo)StreamJob.parseTableInfo(this.output_), (JobConf)this.jobConf_);
        }
        if (this.verbose_) {
            this.listJobConfProperties();
        }
    }

    protected void listJobConfProperties() {
        this.msg("==== JobConf properties:");
        TreeMap sorted = new TreeMap();
        for (Map.Entry en : this.jobConf_) {
            sorted.put(en.getKey(), en.getValue());
        }
        for (Map.Entry en : sorted.entrySet()) {
            this.msg((String)en.getKey() + "=" + (String)en.getValue());
        }
        this.msg("====");
    }

    public int submitAndMonitorJob() throws Exception {
        this.running_ = JobClient.submitJob((JobConf)this.jobConf_);
        LOG.debug((Object)"submit job done");
        if (this.background_) {
            LOG.info((Object)"Job is running in background.");
        } else {
            this.running_.waitForCompletion();
            if (!this.running_.isSuccessful()) {
                return 1;
            }
        }
        return 0;
    }

    private Map<Integer, KeyDescription> parseKeyOptions(String options) {
        HashMap<Integer, KeyDescription> keys = new HashMap<Integer, KeyDescription>();
        StringTokenizer st = new StringTokenizer(options, "nr,", true);
        while (st.hasMoreTokens()) {
            int fieldId;
            String token = st.nextToken();
            try {
                fieldId = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid key options format, expect field number at '" + token + "'");
            }
            KeyDescription keyDesc = new KeyDescription();
            while (st.hasMoreTokens() && !(token = st.nextToken()).equals(",")) {
                if (token.equals("n")) {
                    keyDesc.numeric = true;
                    continue;
                }
                if (token.equals("r")) {
                    keyDesc.reverse = true;
                    continue;
                }
                throw new IllegalArgumentException("invalid key options format, unknown option '" + token + "'");
            }
            keys.put(fieldId, keyDesc);
        }
        return keys;
    }

    public static void main(String[] args) {
        StreamJob job = new StreamJob();
        try {
            System.exit(job.run(args));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static class KeyDescription {
        boolean numeric = false;
        boolean reverse = false;

        private KeyDescription() {
        }
    }
}

