/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.streaming;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.TaskContext;
import com.aliyun.odps.mapred.bridge.streaming.PipeMapRed;
import com.aliyun.odps.mapred.bridge.streaming.io.InputWriter;
import com.aliyun.odps.mapred.bridge.streaming.io.OutputReader;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.UTF8ByteArrayUtils;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PipeMapper
extends PipeMapRed
implements Mapper {
    private boolean ignoreKey = true;
    private boolean skipping = false;
    private byte[] mapOutputFieldSeparator;
    private byte[] mapInputFieldSeparator;
    private int numOfMapOutputKeyFields = 1;

    @Override
    String getPipeCommand(JobConf job) {
        String str = job.get("stream.map.streamprocessor");
        if (str == null) {
            return str;
        }
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("stream.map.streamprocessor in jobconf not found");
            return null;
        }
    }

    @Override
    boolean getDoPipe() {
        return true;
    }

    public void setup(Mapper.TaskContext context) throws IOException {
        TableInfo ti = context.getInputTableInfo();
        String input = "/" + ti.getProjectName() + "/" + ti.getTableName() + "/" + ti.getPartPath();
        context.getJobConf().set("map.input.file", input);
        context.getJobConf().set("map.input.columns", StringUtils.join((Object[])ti.getCols(), (String)","));
        try {
            Gson gson = GsonObjectBuilder.get();
            Map inputConfigs = (Map)gson.fromJson(context.getJobConf().get("stream.map.input.configs", null), new TypeToken<Map<String, Object>>(){}.getType());
            if (inputConfigs == null) {
                throw new RuntimeException("input configs is null");
            }
            String inputKey = ti.getProjectName() + "." + ti.getTableName();
            Map inputConfig = (Map)inputConfigs.get(inputKey);
            for (Map.Entry e : inputConfig.entrySet()) {
                context.getJobConf().set((String)e.getKey(), (String)e.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("fail to apply input configs");
        }
        this.configure(context.getJobConf());
    }

    public void cleanup(Mapper.TaskContext context) throws IOException {
        this.close();
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            this.mapOutputFieldSeparator = UTF8ByteArrayUtils.unescapeSeparator((String)job.get("stream.map.output.field.separator", "\t")).getBytes("UTF-8");
            this.mapInputFieldSeparator = UTF8ByteArrayUtils.unescapeSeparator((String)job.get("stream.map.input.field.separator", "\t")).getBytes("UTF-8");
            this.numOfMapOutputKeyFields = job.getInt("stream.num.map.output.key.fields", 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The current system does not support UTF-8 encoding!", e);
        }
    }

    public void map(long keyRaw, Record valueRaw, Mapper.TaskContext context) throws IOException {
        block7: {
            if (this.outThread_ == null) {
                this.startOutputThreads((TaskContext)context);
            }
            if (this.outerrThreadsThrowable != null) {
                this.mapRedFinished();
                throw new IOException("MROutput/MRErrThread failed:", this.outerrThreadsThrowable);
            }
            try {
                ++this.numRecRead_;
                this.maybeLogRecord();
                if (this.numExceptions_ == 0) {
                    this.inWriter_.writeValue(valueRaw);
                    if (this.skipping) {
                        this.clientOut_.flush();
                    }
                } else {
                    ++this.numRecSkipped_;
                }
            }
            catch (IOException io) {
                ++this.numExceptions_;
                if (this.numExceptions_ <= 1 && this.numRecWritten_ >= this.minRecWrittenToEnableSkip_) break block7;
                LOG.info((Object)this.getContext(), (Throwable)io);
                this.mapRedFinished();
                throw io;
            }
        }
    }

    public void close() {
        this.mapRedFinished();
    }

    @Override
    public byte[] getInputSeparator() {
        return this.mapInputFieldSeparator;
    }

    @Override
    public byte[] getFieldSeparator() {
        return this.mapOutputFieldSeparator;
    }

    @Override
    public int getNumOfKeyFields() {
        return this.numOfMapOutputKeyFields;
    }

    @Override
    InputWriter createInputWriter() throws IOException {
        return super.createInputWriter(this.mapInputWriterClass_);
    }

    @Override
    OutputReader createOutputReader() throws IOException {
        return super.createOutputReader(this.mapOutputReaderClass_);
    }
}

