/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.IntervalYearMonth;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.io.ArrayWritable;
import com.aliyun.odps.io.BigDecimalWritable;
import com.aliyun.odps.io.BooleanWritable;
import com.aliyun.odps.io.ByteWritable;
import com.aliyun.odps.io.BytesWritable;
import com.aliyun.odps.io.CharWritable;
import com.aliyun.odps.io.DateWritable;
import com.aliyun.odps.io.DatetimeWritable;
import com.aliyun.odps.io.DoubleWritable;
import com.aliyun.odps.io.FloatWritable;
import com.aliyun.odps.io.IntWritable;
import com.aliyun.odps.io.IntervalDayTimeWritable;
import com.aliyun.odps.io.IntervalYearMonthWritable;
import com.aliyun.odps.io.LongWritable;
import com.aliyun.odps.io.MapWritable;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.ShortWritable;
import com.aliyun.odps.io.StructWritable;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.TimestampWritable;
import com.aliyun.odps.io.VarcharWritable;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;

public class WritableRecord
implements Record {
    private Column[] columns;
    private final Writable[] values;
    private boolean[] accessMarks;
    private boolean enableColumnAccessStat;
    private static final String STRING_CHARSET = "UTF-8";
    private HashMap<String, Integer> nameMap = new HashMap();

    public WritableRecord(Column[] columns) {
        if (columns == null) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.values = new Writable[columns.length];
        this.accessMarks = new boolean[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String colName = columns[i].getName() == null ? null : columns[i].getName().toLowerCase();
            this.nameMap.put(colName, i);
        }
    }

    public int getColumnCount() {
        return this.values.length;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public void set(int idx, Object value) {
        if (value == null || value.equals(NullWritable.get())) {
            this.values[idx] = null;
            return;
        }
        if (value instanceof Writable) {
            this.values[idx] = (Writable)value;
            return;
        }
        switch (this.columns[idx].getType()) {
            case STRING: {
                if (value instanceof String) {
                    this.setString(idx, (String)value);
                    break;
                }
                this.setString(idx, (byte[])value);
                break;
            }
            case BIGINT: {
                if (value instanceof Long) {
                    this.setBigint(idx, (Long)value);
                    break;
                }
                if (value instanceof Integer) {
                    this.setBigint(idx, new Long(((Integer)value).intValue()));
                    break;
                }
                throw new RuntimeException("Unsupported value type " + value.getClass().getName() + " for column type " + this.columns[idx].getType());
            }
            case BOOLEAN: {
                this.setBoolean(idx, (Boolean)value);
                break;
            }
            case DOUBLE: {
                if (value instanceof Double) {
                    this.setDouble(idx, (Double)value);
                    break;
                }
                if (value instanceof Float) {
                    this.setDouble(idx, new Double(((Float)value).floatValue()));
                    break;
                }
                throw new RuntimeException("Unsupported value type " + value.getClass().getName() + " for column type " + this.columns[idx].getType());
            }
            case DATETIME: {
                this.setDatetime(idx, (java.util.Date)value);
                break;
            }
            case DECIMAL: {
                if (value instanceof Long) {
                    this.setDecimal(idx, new BigDecimal((Long)value));
                    break;
                }
                if (value instanceof Integer) {
                    this.setDecimal(idx, new BigDecimal((Integer)value));
                    break;
                }
                if (value instanceof Double) {
                    this.setDecimal(idx, new BigDecimal((Double)value));
                    break;
                }
                if (value instanceof Float) {
                    this.setDecimal(idx, new BigDecimal(((Float)value).floatValue()));
                    break;
                }
                if (value instanceof BigDecimal) {
                    this.setDecimal(idx, (BigDecimal)value);
                    break;
                }
                this.setDecimal(idx, new BigDecimal((String)value));
                break;
            }
            case TINYINT: {
                this.setTinyint(idx, (Byte)value);
                break;
            }
            case SMALLINT: {
                this.setSmallint(idx, (Short)value);
                break;
            }
            case INT: {
                this.setInt(idx, (Integer)value);
                break;
            }
            case FLOAT: {
                this.setFloat(idx, (Float)value);
                break;
            }
            case CHAR: {
                this.setChar(idx, (Char)value);
                break;
            }
            case VARCHAR: {
                this.setVarchar(idx, (Varchar)value);
                break;
            }
            case DATE: {
                this.setDate(idx, (Date)value);
                break;
            }
            case TIMESTAMP: {
                this.setTimestamp(idx, (Timestamp)value);
                break;
            }
            case BINARY: {
                this.setBinary(idx, (Binary)value);
                break;
            }
            case INTERVAL_DAY_TIME: {
                this.setIntervalDayTime(idx, (IntervalDayTime)value);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                this.setIntervalYearMonth(idx, (IntervalYearMonth)value);
                break;
            }
            case STRUCT: 
            case MAP: 
            case ARRAY: {
                this.values[idx] = (Writable)value;
            }
            default: {
                throw new RuntimeException("Unsupported type " + this.columns[idx].getType());
            }
        }
    }

    public Object get(int idx) {
        switch (this.columns[idx].getType()) {
            case STRING: {
                return this.getString(idx);
            }
            case BIGINT: {
                return this.getBigint(idx);
            }
            case BOOLEAN: {
                return this.getBoolean(idx);
            }
            case DOUBLE: {
                return this.getDouble(idx);
            }
            case DATETIME: {
                return this.getDatetime(idx);
            }
            case DECIMAL: {
                return this.getDecimal(idx);
            }
            case TINYINT: {
                return this.getTinyint(idx);
            }
            case SMALLINT: {
                return this.getSmallint(idx);
            }
            case INT: {
                return this.getInt(idx);
            }
            case FLOAT: {
                return this.getFloat(idx);
            }
            case CHAR: {
                return this.getChar(idx);
            }
            case VARCHAR: {
                return this.getVarchar(idx);
            }
            case DATE: {
                return this.getDate(idx);
            }
            case TIMESTAMP: {
                return this.getTimestamp(idx);
            }
            case BINARY: {
                return this.getBinary(idx);
            }
            case INTERVAL_DAY_TIME: {
                return this.getIntervalDayTime(idx);
            }
            case INTERVAL_YEAR_MONTH: {
                return this.getIntervalYearMonth(idx);
            }
            case STRUCT: 
            case MAP: 
            case ARRAY: {
                if (this.enableColumnAccessStat) {
                    this.columnAccessMark(idx);
                }
                return this.values[idx];
            }
        }
        throw new RuntimeException("Unsupported type " + this.columns[idx].getType());
    }

    public void set(String columnName, Object value) {
        this.set(this.getColumnIndex(columnName), value);
    }

    public Object get(String columnName) {
        return this.get(this.getColumnIndex(columnName));
    }

    public void setBigint(int idx, Long value) {
        if (value != null && value == Long.MIN_VALUE) {
            throw new IllegalArgumentException("InvalidData: Bigint out of range.");
        }
        this.values[idx] = value == null ? null : new LongWritable(value.longValue());
    }

    public Long getBigint(int idx) {
        if (this.enableColumnAccessStat) {
            this.columnAccessMark(idx);
        }
        if (this.values[idx] == null) {
            return null;
        }
        return ((LongWritable)this.values[idx]).get();
    }

    public void setBigint(String columnName, Long value) {
        this.setBigint(this.getColumnIndex(columnName), value);
    }

    public Long getBigint(String columnName) {
        return this.getBigint(this.getColumnIndex(columnName));
    }

    public void setDouble(int idx, Double value) {
        this.values[idx] = value == null ? null : new DoubleWritable(value.doubleValue());
    }

    public Double getDouble(int idx) {
        if (this.enableColumnAccessStat) {
            this.columnAccessMark(idx);
        }
        if (this.values[idx] == null) {
            return null;
        }
        return ((DoubleWritable)this.values[idx]).get();
    }

    public void setDouble(String columnName, Double value) {
        this.setDouble(this.getColumnIndex(columnName), value);
    }

    public Double getDouble(String columnName) {
        return this.getDouble(this.getColumnIndex(columnName));
    }

    public void setBoolean(int idx, Boolean value) {
        this.values[idx] = value == null ? null : new BooleanWritable(value.booleanValue());
    }

    public Boolean getBoolean(int idx) {
        if (this.enableColumnAccessStat) {
            this.columnAccessMark(idx);
        }
        if (this.values[idx] == null) {
            return null;
        }
        return ((BooleanWritable)this.values[idx]).get();
    }

    public void setBoolean(String columnName, Boolean value) {
        this.setBoolean(this.getColumnIndex(columnName), value);
    }

    public Boolean getBoolean(String columnName) {
        return this.getBoolean(this.getColumnIndex(columnName));
    }

    public void setDatetime(int idx, java.util.Date value) {
        this.values[idx] = value == null ? null : new DatetimeWritable(value.getTime());
    }

    public java.util.Date getDatetime(int idx) {
        if (this.enableColumnAccessStat) {
            this.columnAccessMark(idx);
        }
        if (this.values[idx] == null) {
            return null;
        }
        return new java.util.Date(((DatetimeWritable)this.values[idx]).get());
    }

    public void setDatetime(String columnName, java.util.Date value) {
        this.setDatetime(this.getColumnIndex(columnName), value);
    }

    public java.util.Date getDatetime(String columnName) {
        return this.getDatetime(this.getColumnIndex(columnName));
    }

    public void setString(int idx, String value) {
        try {
            this.setString(idx, value == null ? null : value.getBytes(STRING_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public String getString(int idx) {
        if (this.enableColumnAccessStat) {
            this.columnAccessMark(idx);
        }
        if (this.values[idx] == null) {
            return null;
        }
        return ((Text)this.values[idx]).toString();
    }

    public void setString(String columnName, String value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    public String getString(String columnName) {
        return this.getString(this.getColumnIndex(columnName));
    }

    public void setString(int idx, byte[] value) {
        this.values[idx] = value == null ? null : new Text(value);
    }

    public void setString(String columnName, byte[] value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    public byte[] getBytes(int idx) {
        Text o;
        if (this.enableColumnAccessStat) {
            this.columnAccessMark(idx);
        }
        if ((o = (Text)this.values[idx]) == null) {
            return null;
        }
        return Arrays.copyOfRange(o.getBytes(), 0, o.getLength());
    }

    public byte[] getBytes(String columnName) {
        return this.getBytes(this.getColumnIndex(columnName));
    }

    public void set(Object[] values) {
        if (values == null || this.columns.length != values.length) {
            throw new IllegalArgumentException("InvalidData: the parameter is null or length not match.");
        }
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    public Object[] toArray() {
        Object[] rt = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            rt[i] = this.get(i);
        }
        return rt;
    }

    public Writable[] toWritableArray() {
        if (this.enableColumnAccessStat) {
            for (int idx = 0; idx < this.getColumnCount(); ++idx) {
                this.columnAccessMark(idx);
            }
        }
        return this.values;
    }

    private int getColumnIndex(String name) {
        Integer idx = this.nameMap.get(name.toLowerCase());
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name);
        }
        return idx;
    }

    void setEnableColumnAccessStat(boolean isEnable) {
        this.enableColumnAccessStat = isEnable;
    }

    void columnAccessMark(int idx) {
        this.accessMarks[idx] = true;
    }

    int getColumnAccessedNum() {
        int cnt = 0;
        for (int i = 0; i < this.accessMarks.length; ++i) {
            if (!this.accessMarks[i]) continue;
            ++cnt;
        }
        return cnt;
    }

    public void setDecimal(int idx, BigDecimal value) {
        this.values[idx] = value == null ? null : new BigDecimalWritable(value);
    }

    public BigDecimal getDecimal(int idx) {
        if (this.enableColumnAccessStat) {
            this.columnAccessMark(idx);
        }
        if (this.values[idx] == null) {
            return null;
        }
        return ((BigDecimalWritable)this.values[idx]).get();
    }

    public void setDecimal(String columnName, BigDecimal value) {
        this.setDecimal(this.getColumnIndex(columnName), value);
    }

    public BigDecimal getDecimal(String columnName) {
        return this.getDecimal(this.getColumnIndex(columnName));
    }

    private <T> T getInternal(int idx) {
        if (this.enableColumnAccessStat) {
            this.columnAccessMark(idx);
        }
        return (T)(this.values[idx] == null ? null : this.values[idx]);
    }

    public void setChar(int idx, Char value) {
        this.values[idx] = value == null ? null : new CharWritable(value);
    }

    public void setChar(String columnName, Char value) {
        this.setChar(this.getColumnIndex(columnName), value);
    }

    public Char getChar(int idx) {
        CharWritable writable = (CharWritable)this.getInternal(idx);
        return writable == null ? null : writable.get();
    }

    public Char getChar(String columnName) {
        return this.getChar(this.getColumnIndex(columnName));
    }

    public void setVarchar(int idx, Varchar value) {
        this.values[idx] = value == null ? null : new VarcharWritable(value);
    }

    public void setVarchar(String columnName, Varchar value) {
        this.setVarchar(this.getColumnIndex(columnName), value);
    }

    public Varchar getVarchar(int idx) {
        VarcharWritable writable = (VarcharWritable)this.getInternal(idx);
        return writable == null ? null : writable.get();
    }

    public Varchar getVarchar(String columnName) {
        return this.getVarchar(this.getColumnIndex(columnName));
    }

    public void setDate(int idx, Date value) {
        this.values[idx] = value == null ? null : new DateWritable(value.getTime());
    }

    public Date getDate(int idx) {
        DateWritable writable = (DateWritable)this.getInternal(idx);
        return writable == null ? null : new Date(((DateWritable)this.values[idx]).get());
    }

    public void setDate(String columnName, Date value) {
        this.setDate(this.getColumnIndex(columnName), value);
    }

    public Date getDate(String columnName) {
        return this.getDate(this.getColumnIndex(columnName));
    }

    public void setTimestamp(int idx, Timestamp value) {
        this.values[idx] = value == null ? null : new TimestampWritable(value.getTime());
    }

    public Timestamp getTimestamp(int idx) {
        TimestampWritable writable = (TimestampWritable)this.getInternal(idx);
        return writable == null ? null : new Timestamp(writable.get());
    }

    public void setTimestamp(String columnName, Timestamp value) {
        this.setTimestamp(this.getColumnIndex(columnName), value);
    }

    public Timestamp getTimestamp(String columnName) {
        return this.getTimestamp(this.getColumnIndex(columnName));
    }

    public void setFloat(int idx, Float value) {
        this.values[idx] = value == null ? null : new FloatWritable(value.floatValue());
    }

    public void setFloat(String columnName, Float value) {
        this.setFloat(this.getColumnIndex(columnName), value);
    }

    public Float getFloat(int idx) {
        FloatWritable writable = (FloatWritable)this.getInternal(idx);
        return writable == null ? null : Float.valueOf(writable.get());
    }

    public Float getFloat(String columnName) {
        return this.getFloat(this.getColumnIndex(columnName));
    }

    public void setInt(int idx, Integer value) {
        this.values[idx] = value == null ? null : new IntWritable(value.intValue());
    }

    public void setInt(String columnName, Integer value) {
        this.setInt(this.getColumnIndex(columnName), value);
    }

    public Integer getInt(int idx) {
        IntWritable writable = (IntWritable)this.getInternal(idx);
        return writable == null ? null : Integer.valueOf(writable.get());
    }

    public Integer getInt(String columnName) {
        return this.getInt(this.getColumnIndex(columnName));
    }

    public void setTinyint(int idx, Byte value) {
        this.values[idx] = value == null ? null : new ByteWritable(value.byteValue());
    }

    public void setTinyint(String columnName, Byte value) {
        this.setTinyint(this.getColumnIndex(columnName), value);
    }

    public Byte getTinyint(int idx) {
        ByteWritable writable = (ByteWritable)this.getInternal(idx);
        return writable == null ? null : Byte.valueOf(writable.get());
    }

    public Byte getTinyint(String columnName) {
        return this.getTinyint(this.getColumnIndex(columnName));
    }

    public void setSmallint(int idx, Short value) {
        this.values[idx] = value == null ? null : new ShortWritable(value.shortValue());
    }

    public void setSmallint(String columnName, Short value) {
        this.setSmallint(this.getColumnIndex(columnName), value);
    }

    public Short getSmallint(int idx) {
        ShortWritable writable = (ShortWritable)this.getInternal(idx);
        return writable == null ? null : Short.valueOf(writable.get());
    }

    public Short getSmallint(String columnName) {
        return this.getSmallint(this.getColumnIndex(columnName));
    }

    public void setBinary(int idx, Binary value) {
        this.values[idx] = value == null ? null : new BytesWritable(value.data());
    }

    public void setBinary(String columnName, Binary value) {
        this.setBinary(this.getColumnIndex(columnName), value);
    }

    public Binary getBinary(int idx) {
        BytesWritable writable = (BytesWritable)this.getInternal(idx);
        return writable == null ? null : new Binary(writable.getBytes());
    }

    public Binary getBinary(String columnName) {
        return this.getBinary(this.getColumnIndex(columnName));
    }

    public IntervalYearMonth getIntervalYearMonth(int idx) {
        IntervalYearMonthWritable writable = (IntervalYearMonthWritable)this.getInternal(idx);
        return writable == null ? null : writable.get();
    }

    public IntervalYearMonth getIntervalYearMonth(String columnName) {
        return this.getIntervalYearMonth(this.getColumnIndex(columnName));
    }

    public void setIntervalYearMonth(int idx, IntervalYearMonth value) {
        this.values[idx] = value == null ? null : new IntervalYearMonthWritable(value);
    }

    public void setIntervalYearMonth(String columnName, IntervalYearMonth value) {
        this.setIntervalYearMonth(this.getColumnIndex(columnName), value);
    }

    public IntervalDayTime getIntervalDayTime(int idx) {
        IntervalDayTimeWritable writable = (IntervalDayTimeWritable)this.getInternal(idx);
        return writable == null ? null : writable.get();
    }

    public IntervalDayTime getIntervalDayTime(String columnName) {
        return this.getIntervalDayTime(this.getColumnIndex(columnName));
    }

    public void setIntervalDayTime(int idx, IntervalDayTime value) {
        this.values[idx] = value == null ? null : new IntervalDayTimeWritable(value);
    }

    public void setIntervalDayTime(String columnName, IntervalDayTime value) {
        this.setIntervalDayTime(this.getColumnIndex(columnName), value);
    }

    public void setArray(String columnName, Writable value) {
        this.setArray(this.getColumnIndex(columnName), value);
    }

    public void setArray(int idx, Writable value) {
        this.set(idx, (Object)value);
    }

    public void setMap(int idx, Writable value) {
        this.set(idx, (Object)value);
    }

    public void setMap(String columnName, Writable value) {
        this.setMap(this.getColumnIndex(columnName), value);
    }

    public void setStruct(int idx, Writable value) {
        this.set(idx, (Object)value);
    }

    public void setStruct(String columnName, Writable value) {
        this.setStruct(this.getColumnIndex(columnName), value);
    }

    public ArrayWritable getArray(String columnName) {
        return this.getArray(this.getColumnIndex(columnName));
    }

    public ArrayWritable getArray(int idx) {
        return (ArrayWritable)this.getInternal(idx);
    }

    public MapWritable getMap(String columnName) {
        return this.getMap(this.getColumnIndex(columnName));
    }

    public MapWritable getMap(int idx) {
        return (MapWritable)this.getInternal(idx);
    }

    public StructWritable getStruct(int idx) {
        return (StructWritable)this.getInternal(idx);
    }

    public StructWritable getStruct(String columnName) {
        return this.getStruct(this.getColumnIndex(columnName));
    }

    public boolean isNull(int idx) {
        if (this.enableColumnAccessStat) {
            this.columnAccessMark(idx);
        }
        return this.values[idx] == null;
    }

    public boolean isNull(String columnName) {
        return this.isNull(this.getColumnIndex(columnName));
    }

    public Record clone() {
        WritableRecord record = new WritableRecord(this.getColumns());
        for (int i = 0; i < this.values.length; ++i) {
            if (this.enableColumnAccessStat) {
                this.columnAccessMark(i);
            }
            record.values[i] = WritableUtils.clone((Writable)this.values[i], null);
        }
        return record;
    }
}

