/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class NonGroupingRecordIterator
implements Iterator<Record> {
    private WritableRecord value;
    private Object[] prefetch;
    private int curIndex = 0;
    private List<Object[]> valueList;

    public NonGroupingRecordIterator(List<Object[]> curValuelist, WritableRecord value) {
        this.valueList = curValuelist;
        this.value = value;
    }

    private void fillKeyValue(Object[] objs) {
        this.value.set(Arrays.copyOf(objs, this.value.getColumnCount()));
    }

    @Override
    public boolean hasNext() {
        return this.curIndex < this.valueList.size();
    }

    public boolean reset() {
        if (this.prefetch != null) {
            this.fillKeyValue(this.prefetch);
            return true;
        }
        return false;
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.fillKeyValue(this.valueList.get(this.curIndex));
        ++this.curIndex;
        this.prefetch = null;
        return this.value;
    }

    @Override
    public void remove() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prefetch = null;
    }
}

