/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.util.CostResultParser;
import com.aliyun.odps.counter.CounterGroup;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.mapred.EventListener;
import com.aliyun.odps.mapred.JobStatus;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.udf.utils.CounterUtils;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BridgeRunningJob
implements RunningJob {
    protected Instance instance;
    protected JobStatus state = JobStatus.PREP;
    protected Counters counters = new Counters();
    protected String diagnostics = "";
    protected boolean stopped = false;
    private long timeMark = 0L;
    private boolean hasPrintSummary = false;
    private boolean hasPrintResult = false;
    private float mapProgress = 0.0f;
    private float reduceProgress = 0.0f;
    private final String taskName;
    private EventListener event = null;
    private boolean isCountersOk = true;
    private boolean isCostMode = false;

    public BridgeRunningJob(Instance instance, String taskName, EventListener event) {
        this.instance = instance;
        this.taskName = taskName;
        this.event = event;
        this.startUp();
    }

    public String getInstanceID() {
        return this.instance.getId();
    }

    public boolean isComplete() {
        if (this.isFinished()) {
            return true;
        }
        this.updateStatus();
        return this.isFinished();
    }

    public boolean isSuccessful() {
        if (this.isFinished()) {
            return this.state == JobStatus.SUCCEEDED;
        }
        this.updateStatus();
        return this.state == JobStatus.SUCCEEDED;
    }

    public void waitForCompletion() {
        int sleeptime = 1000;
        while (!this.isComplete()) {
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            sleeptime = sleeptime + 500 > 4000 ? 4000 : sleeptime + 500;
        }
        this.event.onComplete();
    }

    private void startUp() {
        try {
            String log = SessionState.get().getOdps().logview().generateLogView(this.instance, 168L);
            System.out.println(log);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JobStatus getJobStatus() {
        if (this.isFinished()) {
            return this.state;
        }
        this.updateStatus();
        return this.state;
    }

    public void killJob() {
        this.stopped = true;
        try {
            this.instance.stop();
        }
        catch (OdpsException ex) {
            throw new RuntimeException("Kill job Failed", ex);
        }
        this.event.onComplete();
    }

    public Counters getCounters() {
        if (!this.isCountersOk) {
            throw new RuntimeException("Get Counters Failed!");
        }
        return this.counters;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    protected boolean isFinished() {
        return this.state == JobStatus.FAILED || this.state == JobStatus.SUCCEEDED || this.state == JobStatus.KILLED;
    }

    protected void updateStatus() {
        try {
            Instance.Status instanceStatus = this.instance.getStatus();
            if (instanceStatus == Instance.Status.RUNNING || instanceStatus == Instance.Status.SUSPENDED) {
                this.state = JobStatus.RUNNING;
            } else if (instanceStatus == Instance.Status.TERMINATED) {
                Instance.TaskStatus taskStatus = (Instance.TaskStatus)this.instance.getTaskStatus().values().iterator().next();
                switch (taskStatus.getStatus()) {
                    case WAITING: 
                    case RUNNING: 
                    case FAILED: {
                        this.state = JobStatus.FAILED;
                        break;
                    }
                    case SUCCESS: {
                        this.state = JobStatus.SUCCEEDED;
                        break;
                    }
                    case CANCELLED: {
                        this.state = JobStatus.KILLED;
                        break;
                    }
                    default: {
                        throw new OdpsException("Got Unknown task status: " + taskStatus.getStatus());
                    }
                }
            } else {
                throw new OdpsException("Got unknown instance status '" + instanceStatus + "'");
            }
            if (this.needPrintProcess() || this.isFinished()) {
                this.printProgress();
            }
        }
        catch (OdpsException ex) {
            throw new RuntimeException(ex);
        }
        if (this.isFinished()) {
            try {
                this.printSummaryAndCollectCounters();
                this.printResult();
            }
            catch (Exception ex) {
                this.isCountersOk = false;
                System.out.println("Get summary failed.");
            }
        }
    }

    private boolean needPrintProcess() {
        long interval;
        long now = System.currentTimeMillis();
        if (now - this.timeMark > (interval = 5000L)) {
            this.timeMark = now;
            return true;
        }
        return false;
    }

    private void printProgress() throws OdpsException {
        PrintStream out = System.out;
        List stages = null;
        stages = this.instance.getTaskProgress(this.taskName);
        if (stages != null && stages.size() != 0) {
            out.print(Instance.getStageProgressFormattedString((List)stages));
            int mappers = 0;
            int reducers = 0;
            this.mapProgress = 0.0f;
            this.reduceProgress = 0.0f;
            for (Instance.StageProgress stage : stages) {
                int totalWorkers = stage.getTotalWorkers();
                if (stage.getName().startsWith("M")) {
                    mappers += totalWorkers;
                    this.mapProgress = (float)((double)this.mapProgress + (double)stage.getFinishedPercentage() / 100.0 * (double)totalWorkers);
                    continue;
                }
                reducers += totalWorkers;
                this.reduceProgress = (float)((double)this.reduceProgress + (double)stage.getFinishedPercentage() / 100.0 * (double)totalWorkers);
            }
            this.mapProgress = mappers == 0 ? 0.0f : this.mapProgress / (float)mappers;
            this.reduceProgress = reducers == 0 ? 0.0f : this.reduceProgress / (float)reducers;
        } else {
            out.print("...");
        }
        out.print('\r');
        out.flush();
    }

    private void printSummaryAndCollectCounters() throws IOException {
        if (this.hasPrintSummary || !this.isSuccessful()) {
            return;
        }
        Instance.TaskSummary taskSummary = null;
        try {
            taskSummary = this.instance.getTaskSummary(this.taskName);
        }
        catch (OdpsException ex) {
            throw new IOException("Get summary encounter error: ", ex);
        }
        if (taskSummary == null) {
            if (System.getProperty("omit.taskstatus.failure", "false").equalsIgnoreCase("true")) {
                System.out.println("No summary in place.");
                return;
            }
            throw new IOException("No summary in place.");
        }
        Map tasks = (Map)taskSummary.get((Object)"Stages");
        for (Object e : tasks.values()) {
            Map task = (Map)e;
            Map countersValue = (Map)task.get("UserCounters");
            if (countersValue == null) continue;
            Counters tmpCounters = CounterUtils.createFromJsonString((String)new GsonBuilder().disableHtmlEscaping().create().toJson((Object)countersValue));
            Iterator iter = tmpCounters.iterator();
            while (iter.hasNext()) {
                if (!((CounterGroup)iter.next()).getName().equals("ODPS_SDK_FRAMEWORK_COUNTER_GROUP")) continue;
                iter.remove();
            }
            this.counters.incrAllCounters(tmpCounters);
        }
        System.out.println(taskSummary.getSummaryText());
        System.out.println(this.counters);
        this.hasPrintSummary = true;
    }

    private void printResult() throws IOException {
        if (!this.hasPrintResult) {
            try {
                Map m = this.instance.getTaskResults();
                this.diagnostics = (String)m.values().iterator().next();
                if (this.state == JobStatus.SUCCEEDED) {
                    if (!StringUtils.isEmpty((String)this.diagnostics)) {
                        if (this.isCostMode) {
                            this.diagnostics = CostResultParser.parse((String)this.diagnostics, (String)"MapReduce");
                        }
                        System.err.println(this.diagnostics);
                    }
                    System.err.println("OK");
                } else if (!StringUtils.isEmpty((String)this.diagnostics)) {
                    System.err.println("FAILED: " + this.diagnostics);
                } else {
                    System.err.println("ERROR: " + this.state.toString());
                }
                this.hasPrintResult = true;
            }
            catch (Exception ex) {
                throw new IOException("Get result encounter error: " + ex.getMessage());
            }
        }
    }

    public float mapProgress() throws IOException {
        if (this.isSuccessful()) {
            return 1.0f;
        }
        return this.mapProgress;
    }

    public float reduceProgress() throws IOException {
        if (this.isSuccessful()) {
            return 1.0f;
        }
        return this.reduceProgress;
    }

    public boolean isCostMode() {
        return this.isCostMode;
    }

    public void setIsCostMode(boolean isCostMode) {
        this.isCostMode = isCostMode;
    }
}

