/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.cupid.common;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.ApplicationMetaUtil;
import com.aliyun.odps.cupid.requestcupid.JobViewUtil;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.cupid.common.BearerTokenGenerator;
import com.aliyun.openservices.odps.console.cupid.common.CupidSessionConf;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SparkJobUtils {
    public static String jobViewService(ExecutionContext executionContext, String instanceId, String applicationId) throws ODPSConsoleException {
        CupidConf conf = CupidSessionConf.getBasicCupidConf(executionContext);
        CupidSession session = new CupidSession(conf);
        CupidTaskParamProtos.ApplicationMeta applicationMeta = SparkJobUtils.getApplicationMeta(instanceId, applicationId, session);
        Level originLevel = Logger.getRootLogger().getLevel();
        Logger.getRootLogger().setLevel(Level.OFF);
        JobViewUtil util = new JobViewUtil(session);
        String jobViewUrl = util.generateJobView(applicationMeta.getInstanceId());
        Logger.getRootLogger().setLevel(originLevel);
        return jobViewUrl;
    }

    public static String logViewService(ExecutionContext ec, String instanceId, String applicationId) throws ODPSConsoleException, OdpsException {
        CupidConf conf = CupidSessionConf.getBasicCupidConf(ec);
        CupidSession session = new CupidSession(conf);
        String logViewHost = session.odps().logview().getLogViewHost();
        String odpsEndpoint = session.odps().getEndpoint();
        String bearerToken = BearerTokenGenerator.getBearerToken(ec);
        Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)ec);
        CupidTaskParamProtos.ApplicationMeta applicationMeta = SparkJobUtils.getApplicationMeta(instanceId, applicationId, session);
        instanceId = applicationMeta.getInstanceId();
        return logViewHost + "/logview/?h=" + odpsEndpoint + "&p=" + odps.getDefaultProject() + "&i=" + instanceId + "&token=" + bearerToken;
    }

    public static CupidTaskParamProtos.ApplicationMetaList getApplicationMetaList(CupidSession session) throws ODPSConsoleException {
        return SparkJobUtils.getApplicationMetaList(session, null);
    }

    public static CupidTaskParamProtos.ApplicationMetaList getApplicationMetaList(CupidSession session, String yarnApplicationState) throws ODPSConsoleException {
        CupidTaskParamProtos.ApplicationMetaList applicationMetaList;
        Level originLevel = Logger.getRootLogger().getLevel();
        Logger.getRootLogger().setLevel(Level.OFF);
        try {
            applicationMetaList = ApplicationMetaUtil.listApplicationMeta((String)"SPARK", (String)yarnApplicationState, (CupidSession)session);
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Get Application Meta List failed.", (Throwable)e);
        }
        Logger.getRootLogger().setLevel(originLevel);
        return applicationMetaList;
    }

    public static CupidTaskParamProtos.ApplicationMeta getApplicationMeta(String instanceId, String applicationId, CupidSession session) throws ODPSConsoleException {
        CupidTaskParamProtos.ApplicationMeta applicationMeta = null;
        Level originLevel = Logger.getRootLogger().getLevel();
        Logger.getRootLogger().setLevel(Level.OFF);
        if (instanceId != null) {
            try {
                applicationMeta = ApplicationMetaUtil.getCupidInstanceMeta((String)instanceId, (CupidSession)session);
            }
            catch (Exception e) {
                throw new ODPSConsoleException("Getting Cupid Instance Meta failed.", (Throwable)e);
            }
        }
        if (applicationId != null) {
            try {
                applicationMeta = ApplicationMetaUtil.getApplicationMeta((String)applicationId, (CupidSession)session);
            }
            catch (Exception e) {
                throw new ODPSConsoleException("Getting Application Meta failed.", (Throwable)e);
            }
        }
        if (applicationMeta == null) {
            throw new ODPSConsoleException("Getting Meta failed.");
        }
        Logger.getRootLogger().setLevel(originLevel);
        return applicationMeta;
    }

    public static void updateApplicationMeta(String applicationId, CupidSession session, CupidTaskParamProtos.ApplicationMeta meta) throws ODPSConsoleException {
        Level originLevel = Logger.getRootLogger().getLevel();
        Logger.getRootLogger().setLevel(Level.OFF);
        try {
            ApplicationMetaUtil.updateApplicationMeta((String)applicationId, (CupidTaskParamProtos.ApplicationMeta)meta, (CupidSession)session);
        }
        catch (Exception e) {
            throw new ODPSConsoleException("update Application Meta failed.", (Throwable)e);
        }
        Logger.getRootLogger().setLevel(originLevel);
    }
}

