/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.CharTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.aliyun.odps.type.TypeInfoParser;
import com.aliyun.odps.type.VarcharTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;

public class SchemaUtils {
    private static final String SEPERATOR = ",";
    private static final String DELIMITER = ":";

    public static Column[] fromString(String str) {
        if (str == null || str.isEmpty()) {
            return new Column[0];
        }
        String remain = str;
        ArrayList<Column> cols = new ArrayList<Column>();
        int pos = 0;
        IllegalArgumentException exception = null;
        while (remain.length() > 0) {
            String tok;
            String[] knv;
            if ((pos = remain.indexOf(SEPERATOR, pos)) < 0) {
                pos = remain.length();
            }
            if ((knv = (tok = remain.substring(0, pos)).split(DELIMITER, 2)).length != 2) {
                throw new IllegalArgumentException("Malformed schema definition, expecting \"name:type\" but was \"" + tok + "\"");
            }
            try {
                TypeInfo typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)knv[1].trim());
                if (typeInfo != null) {
                    exception = null;
                    cols.add(new Column(knv[0].trim(), typeInfo));
                    if (pos == remain.length()) {
                        remain = "";
                        continue;
                    }
                    remain = remain.substring(pos + 1);
                    pos = 0;
                    continue;
                }
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            if (pos == remain.length()) {
                remain = "";
                continue;
            }
            ++pos;
        }
        if (exception != null) {
            throw exception;
        }
        return cols.toArray(new Column[0]);
    }

    public static String toString(Column[] cols) {
        if (cols == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Column c : cols) {
            if (c == null) continue;
            if (sb.length() > 0) {
                sb.append(SEPERATOR);
            }
            if (c.getTypeInfo() != null) {
                sb.append(c.getName()).append(DELIMITER).append(c.getTypeInfo().toString());
                continue;
            }
            sb.append(c.getName()).append(DELIMITER).append(SchemaUtils.getOdpsTypeString(c));
        }
        return sb.toString();
    }

    public static String[] getNames(Column[] cols) {
        String[] names = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            names[i] = cols[i].getName();
        }
        return names;
    }

    public static OdpsType[] getTypes(Column[] cols) {
        OdpsType[] types = new OdpsType[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            types[i] = cols[i].getType();
        }
        return types;
    }

    public static TypeInfo[] getTypeInfos(Column[] cols) {
        TypeInfo[] types = new TypeInfo[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            types[i] = cols[i].getTypeInfo();
        }
        return types;
    }

    private static String getOdpsTypeString(Column tp) {
        StringBuilder sb = new StringBuilder();
        if (tp.getType() == OdpsType.ARRAY) {
            sb.append("ARRAY<");
            sb.append(((OdpsType)tp.getGenericTypeList().get(0)).toString());
            sb.append(">");
        } else if (tp.getType() == OdpsType.MAP) {
            sb.append("MAP<");
            sb.append(((OdpsType)tp.getGenericTypeList().get(0)).toString());
            sb.append(SEPERATOR);
            sb.append(((OdpsType)tp.getGenericTypeList().get(1)).toString());
            sb.append(">");
        } else {
            sb.append(tp.getType().toString());
        }
        return sb.toString();
    }

    private static Column getColumn(String name, String typeStr) {
        name = name.trim();
        if ((typeStr = typeStr.toUpperCase().trim()).startsWith("ARRAY<")) {
            String remain = typeStr.substring(6);
            if (remain.length() < 2 || remain.charAt(remain.length() - 1) != '>') {
                throw new IllegalArgumentException("Malformed schema, not a valid array type: " + typeStr);
            }
            OdpsType elementType = OdpsType.valueOf((String)remain.substring(0, remain.length() - 1));
            Column col = new Column(name, OdpsType.ARRAY);
            col.setGenericTypeList(Arrays.asList(elementType));
            return col;
        }
        if (typeStr.startsWith("MAP<")) {
            String remain = typeStr.substring(4);
            if (remain.length() < 4 || remain.charAt(remain.length() - 1) != '>') {
                throw new IllegalArgumentException("Malformed schema, not a valid map type: " + typeStr);
            }
            String[] knv = (remain = remain.substring(0, remain.length() - 1)).split(SEPERATOR, 2);
            if (knv.length != 2) {
                throw new IllegalArgumentException("Malformed schema , not a valid map type: " + typeStr);
            }
            Column col = new Column(name, OdpsType.MAP);
            col.setGenericTypeList(Arrays.asList(OdpsType.valueOf((String)knv[0]), OdpsType.valueOf((String)knv[1])));
            return col;
        }
        if (typeStr.startsWith("CHAR")) {
            String remain = typeStr.substring(4).trim();
            int length = 255;
            if (!remain.isEmpty()) {
                if (!remain.startsWith("(") || !remain.endsWith(")")) {
                    throw new IllegalArgumentException("Malformed schema , not a valid map type: " + typeStr);
                }
                length = Integer.parseInt(remain.substring(1, remain.length() - 1));
            }
            CharTypeInfo type = TypeInfoFactory.getCharTypeInfo((int)length);
            return new Column(name, (TypeInfo)type);
        }
        if (typeStr.startsWith("VARCHAR")) {
            String remain = typeStr.substring(7).trim();
            int length = 65535;
            if (!remain.isEmpty()) {
                if (!remain.startsWith("(") || !remain.endsWith(")")) {
                    throw new IllegalArgumentException("Malformed schema , not a valid map type: " + typeStr);
                }
                length = Integer.parseInt(remain.substring(1, remain.length() - 1));
            }
            VarcharTypeInfo type = TypeInfoFactory.getVarcharTypeInfo((int)length);
            Column col = new Column(name, (TypeInfo)type);
            return col;
        }
        return new Column(name, OdpsType.valueOf((String)typeStr));
    }
}

